<?php $__env->startPush('head'); ?>
<?php $__env->stopPush(); ?>


<div class="ppt4 container-fluid">

    <div class="d-block rounded p-3 mb-3">
        <h4 class="card-title">FAQ</h4>
        <h6 class="card-subtitle">Forum pertanyaan yang sering di ajukan</h6>
    </div>

    <div class="d-block bg-theme-box rounded-3 overflow-hidden shadow-sm">

        
        <div class="d-flex justify-content-between align-items-center p-3">
            
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(count($selected) > 0): ?>
                <button class="btn btn-outline-danger" data-bs-toggle="modal" data-bs-target="#deleteModal">
                    <i class="fad fa-trash"></i> Hapus (<?php echo e(count($selected)); ?>)
                </button>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
            <button class="btn btn-outline-warning ms-auto" wire:click='addNew()'>
                <i class="fa fa-plus"></i> Add_New
            </button>
        </div>

        <div class="table-responsive">
            <table class="table table-borderless mb-3">
                <thead class="table-header">
                    <tr>
                        <th></th>
                        <th width="32">
                            <input type="checkbox" wire:model.live="selectAll">
                        </th>
                        <th wire:click="sortBy('category')" style="cursor:pointer">
                            Category
                        </th>
                        <th wire:click="sortBy('question')" style="cursor:pointer">
                            Question
                        </th>
                        <th>Status</th>
                        <th wire:click="sortBy('created_at')" style="cursor:pointer">
                            Create Date
                        </th>
                        <th>Actions</th>
                    </tr>
                </thead>

                <tbody class="table-transparent">
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__empty_1 = true; $__currentLoopData = $faqs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $faq): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td></td>
                            <td>
                                <input type="checkbox" value="<?php echo e($faq->faq_id); ?>" wire:model.live="selected">
                            </td>
                            <td>
                                <span class="badge bg-primary"><?php echo e($faq->category ?? 'General'); ?></span>
                            </td>
                            <td><?php echo e(Str::limit($faq->question, 60)); ?></td>
                            <td>
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($faq->is_active): ?>
                                    <span class="badge bg-success">Active</span>
                                <?php else: ?>
                                    <span class="badge bg-secondary">Inactive</span>
                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </td>
                            <td><?php echo e($faq->created_at->format('d M Y')); ?></td>
                            <td>
                                <button class="btn btn-sm btn-info" wire:click="view(<?php echo e($faq->faq_id); ?>)">
                                    <i class="fa fa-eye"></i>
                                </button>
                                <button class="btn btn-sm btn-warning" wire:click="edit(<?php echo e($faq->faq_id); ?>)">
                                    <i class="fa fa-edit"></i>
                                </button>
                                <button class="btn btn-sm btn-danger" wire:click="delete(<?php echo e($faq->faq_id); ?>)">
                                    <i class="fa fa-trash"></i>
                                </button>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="7" class="text-center">
                                <div class="border rounded py-5">
                                    <i class="fad fa-question-circle fa-3x mb-3"></i>
                                    <p class="fs-5 m-0">No FAQ found.</p>
                                </div>
                            </td>
                        </tr>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                </tbody>

            </table>
        </div>



        
        <div class="mb-3">
            <?php echo e($faqs->links('components.utilities.paginate')); ?>

        </div>


    </div>


    <!-- Modal Create Category -->
    <div class="modal fade" id="FaqModal" tabindex="-1" aria-hidden="true" wire:ignore.self>
        <div class="modal-dialog">
            <form wire:submit.prevent="submit" class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Forum Pertanyaan</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">


                    <div class="mb-3">
                        <label class="form-label">Question</label>
                        <input type="text" class="form-control" wire:model.live="field.question" <?php if($isView): echo 'disabled'; endif; ?>>
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['field.question'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="text-danger"><?php echo e($message); ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Answer</label>
                        <textarea class="form-control" rows="4" wire:model.live="field.answer" <?php if($isView): echo 'disabled'; endif; ?>></textarea>
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['field.answer'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="text-danger"><?php echo e($message); ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Category</label>
                        <select class="form-select" wire:model.live="field.category" <?php if($isView): echo 'disabled'; endif; ?>>
                            <option value="General">General</option>
                            <option value="Pricing">Pricing</option>
                            <option value="Project Flow">Project Flow</option>
                            <option value="Technical">Technical</option>
                            <option value="Maintenance">Maintenance</option>
                            <option value="Legal">Legal</option>
                        </select>
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['field.category'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="text-danger"><?php echo e($message); ?></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </div>

                    <div class="mb-3 form-check">
                        <input type="checkbox" class="form-check-input" wire:model.live="field.is_active" <?php if($isView): echo 'disabled'; endif; ?>>
                        <label class="form-check-label">Active</label>
                    </div>


                </div>
                <div class="modal-footer py-2">
                    <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-outline-primary" <?php if($isView): echo 'disabled'; endif; ?>>Changes</button>
                </div>
            </form>
        </div>
    </div>

    <?php echo $__env->make('components.modal.ModalDeleteComfrimed', [
        'title' => 'Data Produk',
        'count' => count($selected),
    ], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
</div>


<?php $__env->startPush('script'); ?>
<?php $__env->stopPush(); ?>
<?php /**PATH C:\Users\safna\Projects\Laravel\aperonit\resources\views/information/faq.blade.php ENDPATH**/ ?>