<!DOCTYPE html>
<html data-theme="<?php echo e($theme); ?>" data-bs-theme="<?php echo e($theme); ?>">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Peronit - <?php echo e($title ?? 'Pages'); ?></title>
    
    <?php echo $__env->yieldPushContent('head'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('/assets/app/css/app.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('/assets/icons/css/all.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('/assets/dist/css/panel-admin.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('/assets/library/css/textEditor.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('/assets/library/css/animated.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('/assets/OwlCarousel/css/owl.carousel.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('/assets/OwlCarousel/css/owl.theme.default.min.css')); ?>">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Nunito:ital,wght@0,200..1000;1,200..1000&family=Pacifico&family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap" rel="stylesheet">
    <?php echo \Livewire\Mechanisms\FrontendAssets\FrontendAssets::styles(); ?>

    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/admin.css']); ?>

</head>

<body>

    <div class="wrapper">
        <div id="nav-progress-wrapper" class="position-fixed start-0 top-0 w-100 d-none" style="z-index:9999;">
            <div class="progress" style="height: 3px;">
                <div id="nav-progress-bar" class="progress-bar text-them bg-theme-box" style="width: 0%; transition: width 0.2s;">
                </div>
            </div>
        </div>


        <div class="slider" id="sliderExample">
            <div class="slider-head">
                <div class="lh-1">
                    <p class="text-them fw-bold mb-0"><?php echo e(auth('admins')->user()->username); ?></p>
                    <small class="text-them-sec"><?php echo e(auth('admins')->user()->email); ?></small>
                </div>
            </div>
            <div class="slider-body">
                <div class="container">
                    <nav class="nav flex-column" id="sidebar-menu">
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $menus; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $menu): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                        
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($menu->type === 'separator'): ?>
                        <hr class="soft text-them my-2">
                        <?php continue; ?>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>


                        <?php
                        // Ambil semua route anak + parent
                        $allRoutes = collect([$menu->route])->merge($menu->children->pluck('route'))->filter()->map(fn($r) => $r . '*')->toArray();
                        $isActive = request()->routeIs($allRoutes);
                        ?>


                        
                        <a class="nav-link slider-link <?php if($menu->children->count() == 0): ?> <?php echo e($isActive ? 'active' : ''); ?> <?php else: ?> <?php echo e($isActive ? '' : 'collapsed'); ?> <?php endif; ?>"
                            href="<?php echo e($menu->url); ?>"
                            <?php if($menu->children->count()): ?>
                                data-bs-toggle="collapse"
                                data-bs-target="#menu-<?php echo e($menu->menu_id); ?>"
                                aria-expanded="<?php echo e($isActive ? 'true' : 'false'); ?>"
                            <?php else: ?>
                                wire:navigate
                            <?php endif; ?>
                            >
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($menu->icon): ?>
                            <i class="<?php echo e($menu->icon); ?>"></i>
                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            <span class="text-capitalize"><?php echo e($menu->name); ?></span>

                            <?php if($menu->children->count()): ?>
                            <i class="fa-solid fa-chevron-left arrow-icon"></i>
                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        </a>


                        
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($menu->children->count()): ?>
                        <div id="menu-<?php echo e($menu->menu_id); ?>"
                            class="accordion-collapse collapse <?php echo e($isActive ? 'show' : ''); ?>"
                            data-bs-parent="#sidebar-menu">
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $menu->children; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $child): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                            
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($child->type === 'separator'): ?>
                            <hr class="soft text-them">
                            <?php continue; ?>
                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                            <a href="<?php echo e($child->url); ?>" 
                                class="nav-link slider-link ps-3 <?php echo e(request()->routeIs($child->route . '*') ? 'active' : ''); ?>"
                                wire:navigate.hover>
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($child->icon): ?>
                                <i class="<?php echo e($child->icon); ?>"></i>
                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                <span class="text-capitalize"><?php echo e($child->name); ?></span>
                            </a>

                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        </div>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                        <a class="nav-link slider-link" type="button" id="LogOut">
                            <i class="fad fa-sign-out slider-icons"></i>LogOut
                        </a>
                    </nav>
                </div>
            </div>
        </div>

        <main class="pages">
            <nav class="navbar navbar-expand-md navbar-light">
                <div class="container-fluid">
                    <button id="sliderButton" class="btn ms-auto d-block d-md-none" type="button">
                        <i class="fas fa-bars fa-lg fa-fw"></i>
                    </button>
                    <div class="collapse navbar-collapse" id="navbarID">
                        <div class="navbar-nav gap-2 ms-auto">
                            <a class="nav-link text-them-sec" aria-current="page" href="#">
                                <i class="fas fa-bell fa-lg fa-fw"></i>
                            </a>
                            <a class="nav-link text-them-sec" aria-current="page" href="#">
                                <i class="fas fa-envelope fa-lg fa-fw"></i>
                            </a>
                            <a class="nav-link text-them-sec" aria-current="page" href="#">
                                <i class="fas fa-user fa-lg fa-fw"></i>
                            </a>
                        </div>
                    </div>
                </div>
            </nav>
            <section class="pages-main">
                <?php echo e($slot); ?>

            </section>
        </main>
    </div>




    <div id="logoutModal" class="modal fade" tabindex="-1">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-body">
                    <div class="text-center pt-5 pb-3">
                        <i class="fas fa-sign-out-alt fa-5x fa-fw"></i>
                        <p>Anda yakin ingin keluar applikasi!</p>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Tidak</button>
                    <a href="#" class="btn btn-primary">Iya, keluar</a>
                </div>
            </div>
        </div>
    </div>


    <div class="sliderBackground" id="sliderBackground"></div>
    <script src="<?php echo e(asset('/assets/library/js/jquery.js')); ?>"></script>
    <script src="<?php echo e(asset('/assets/library/js/popper.js')); ?>"></script>
    <script src="<?php echo e(asset('/assets/library/js/alert.js')); ?>"></script>
    <script src="<?php echo e(asset('/assets/library/js/alert-handler.js')); ?>"></script>
    <script src="<?php echo e(asset('/assets/app/js/app.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/assets/dist/js/panel-admin.js')); ?>"></script>
    <script src="<?php echo e(asset('/assets/OwlCarousel/owl.carousel.min.js')); ?>"></script>
    
    <?php echo $__env->yieldPushContent('script'); ?>
    <?php echo \Livewire\Mechanisms\FrontendAssets\FrontendAssets::scripts(); ?>

    <?php echo app('Illuminate\Foundation\Vite')(['resources/js/admin.js']); ?>
</body>

</html><?php /**PATH C:\Users\safna\Projects\Laravel\aperonit\resources\views/components/layouts/panel-admin.blade.php ENDPATH**/ ?>