<?php $__env->startPush('head'); ?>
<title>PeronIT - Setup Konten Banner</title>
<?php $__env->stopPush(); ?>

<div>

    <div class="ppt4 container-fluid">
        
        <div class="d-flex justify-content-between align-items-center rounded bg-theme-box shadow-sm p-3 mb-3">
            <div>
                <h2 class="text-them fw-bold mb-0">Content Banner</h2>
                <p class="text-them-sec mb-0">Selamat datang di konten halaman utama</p>
            </div>
            <div>
                <button class="btn btn-secondary" type="button" wire:click="new">
                    <i class="fas fa-plus fa-sm fa-fw"></i>
                    <span class="d-none d-lg-inline">Tambah</span>
                </button>
            </div>
        </div>

        <div class="d-block rounded shadow bg-theme-box mb-3">
            <div class="d-flex gap-3 align-items-center py-3 px-4">
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(count($selected) > 0): ?>
                <button class="btn btn-outline-danger" data-bs-toggle="modal" data-bs-target="#deleteModal">
                    <i class="fad fa-trash"></i> Hapus (<?php echo e(count($selected)); ?>)
                </button>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                <div class="d-flex align-items-center ms-auto">
                    <input type="text" wire:model.live="search" class="form-control pe-4"
                        placeholder="Search Product...">
                    <i class="fad fa-search fa-sm" style="margin-left: -32px"></i>
                </div>
            </div>
            <div class="table-responsive">
                <table class="table table-borderless">
                    <thead class="table-header text-capitalize">
                        <tr>
                            <th style="widht: 24px"></th>
                            <th>
                                <input type="checkbox" wire:model.live="selectAll">
                            </th>
                            <th wire:click="sortBy('title')" style="cursor:pointer">
                                <div class="d-flex justify-content-between align-items-center">
                                    <span>title</span>
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($sortField === 'title'): ?>
                                    <i class="fa fa-sort-<?php echo e($sortDirection); ?>"></i>
                                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                </div>
                            </th>
                            <th>Description</th>
                            <th wire:click="sortBy('is_active')" style="cursor:pointer">
                                <div class="d-flex justify-content-between align-items-center">
                                    <span>Status</span>
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($sortField === 'is_active'): ?>
                                    <i class="fa fa-sort-<?php echo e($sortDirection); ?>"></i>
                                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                </div>
                            </th>
                            <th wire:click="sortBy('created_at')" style="cursor:pointer">
                                <div class="d-flex justify-content-between align-items-center">
                                    <span>Date</span>
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($sortField === 'created_at'): ?>
                                    <i class="fa fa-sort-<?php echo e($sortDirection); ?>"></i>
                                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                </div>
                            </th>
                            <th width="120" class="text-nowrap">Actions</th>
                            <th style="widht: 24px"></th>
                        </tr>
                    </thead>
                    <tbody class="table-transparent">
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__empty_1 = true; $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td style="widht: 24px"></td>
                            <td>
                                <input type="checkbox" value="<?php echo e($item->banner_id); ?>" wire:model.live="selected">
                            </td>
                            <td><?php echo e($item->title); ?></td>
                            <td><?php echo e($item->description); ?></td>
                            <td>
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($item->is_active): ?>
                                <span class="badge bg-success">Active</span>
                                <?php else: ?>
                                <span class="badge bg-secondary">Inactive</span>
                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </td>
                            <td><?php echo e($item->created_at); ?></td>
                            <td width="120" class="text-nowrap">
                                <button class="btn btn-sm btn-info" wire:click="show(<?php echo e($item->banner_id); ?>)">
                                    <i class="fa fa-eye"></i>
                                </button>
                                <button class="btn btn-sm btn-warning" wire:click="edit(<?php echo e($item->banner_id); ?>)">
                                    <i class="fa fa-edit"></i>
                                </button>
                                <button class="btn btn-sm btn-danger" wire:click="delete(<?php echo e($item->banner_id); ?>)">
                                    <i class="fa fa-trash"></i>
                                </button>
                            </td>
                            <td style="widht: 24px"></td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="9" class="text-center">
                                <div class="border rounded py-5">
                                    <i class="fad fa-box-open fa-3x fa-fw"></i>
                                    <p class="fs-3 m-0">No categories found.</p>
                                </div>
                            </td>
                        </tr>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    
    <div class="modal fade" id="modalBanner" wire:ignore.self>
        <div class="modal-dialog modal-xl">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Tambah Banner</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>

                <div class="modal-body">
                    <div class="row g-3">
                        
                        <div class="col-12 col-lg-7">
                            
                            <div class="mb-3">
                                <label class="form-label fw-bold">Preview Desktop</label>
                                <div class="position-relative rounded overflow-hidden ratio ratio-21x9">
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($form['image_desktop'] && method_exists($form['image_desktop'],
                                    'temporaryUrl')): ?>
                                    <img src="<?php echo e($form['image_desktop']->temporaryUrl()); ?>"
                                        class="img-fluid position-absolute object-fit-cover">

                                    <?php elseif($form['image_desktop']): ?>
                                    <img src="<?php echo e($form['image_path'] . $form['image_desktop']); ?>"
                                        alt="<?php echo e($form['title']); ?>" class="img-fluid position-absolute object-fit-cover">
                                    <?php else: ?>
                                    <div
                                        class="bg-secondary w-100 h-100 d-flex align-items-center justify-content-center text-light">
                                        No Image</div>
                                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                                    <div class="d-flex align-items-center container"
                                        style="color: <?php echo e($form['text_color']); ?>; justify-content: <?php echo e($form['text_position']); ?>">
                                        <div class="w-50"
                                            style="color: <?php echo e($form['text_color']); ?>; text-align: <?php echo e($form['text_position']); ?>">
                                            <h3 class="fw-bold mb-2"><?php echo e($form['title'] ?: 'Banner Title'); ?></h3>
                                            <p class="mb-3"><?php echo e($form['description'] ?: 'Banner description...'); ?></p>
                                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($form['link']): ?>
                                            <a href="#" class="btn btn-sm px-3"
                                                style="color : <?php echo e($form['text_color']); ?>; border: 1px solid <?php echo e($form['text_color']); ?>;">
                                                <?php echo e($form['link_text'] ?: 'Button Text'); ?>

                                            </a>
                                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            
                            <div class="mb-3" style="width: 25rem;">
                                <label class="form-label fw-bold">Preview Mobile</label>
                                <div class="position-relative rounded overflow-hidden ratio ratio-1x1">
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($form['image_mobile'] && method_exists($form['image_mobile'], 'temporaryUrl')): ?>
                                    <img src="<?php echo e($form['image_mobile']->temporaryUrl()); ?>"
                                        class="img-fluid position-absolute object-fit-cover">
                                    <?php elseif($form['image_mobile']): ?>
                                    <img src="<?php echo e($form['image_path'] . $form['image_mobile']); ?>"
                                        alt="<?php echo e($form['title']); ?>" class="img-fluid position-absolute object-fit-cover">
                                    <?php else: ?>
                                    <div
                                        class="bg-secondary w-100 h-100 d-flex align-items-center justify-content-center text-light">
                                        No Image</div>
                                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                    <div class="d-flex flex-column justify-content-end text-center container pb-5"
                                        style="color: <?php echo e($form['text_color']); ?>;">
                                        <strong><?php echo e($form['title'] ?: 'Title'); ?></strong>
                                        <small><?php echo e($form['description'] ?: 'Description'); ?></small>
                                    </div>
                                </div>
                            </div>
                        </div>

                        
                        <div class="col-12 col-lg-5">
                            <div class="mb-3">
                                <label class="form-label">Title</label>
                                <input type="text" class="form-control" wire:model.live="form.title">
                            </div>

                            <div class="mb-3">
                                <label class="form-label">Description</label>
                                <textarea class="form-control" rows="2" wire:model.live="form.description"></textarea>
                            </div>

                            <div class="row g-2 mb-3">
                                <div class="col-6">
                                    <label class="form-label">Link</label>
                                    <input type="text" class="form-control" wire:model.live="form.link">
                                </div>
                                <div class="col-6">
                                    <label class="form-label">Link Text</label>
                                    <input type="text" class="form-control" wire:model.live="form.link_text">
                                </div>
                            </div>

                            <div class="mb-3">
                                <label class="form-label">Text Position</label>
                                <div>
                                    <label class="me-2"><input type="radio" wire:model.live="form.text_position"
                                            value="left">
                                        Left</label>
                                    <label class="me-2"><input type="radio" wire:model.live="form.text_position"
                                            value="center">
                                        Center</label>
                                    <label><input type="radio" wire:model.live="form.text_position" value="right">
                                        Right</label>
                                </div>
                            </div>

                            <div class="mb-3">
                                <label class="form-label fw-bold">Text Color</label>
                                <div class="d-flex align-items-center gap-3">
                                    <input type="color" class="form-control form-control-color p-0 border-0"
                                        style="width: 3rem; height: 2.5rem;" wire:model.live="form.text_color">
                                    <span class="small text-muted"><?php echo e($form['text_color']); ?></span>
                                </div>
                                <small class="text-muted">Pilih warna teks banner sesuai gambar (misalnya putih
                                    untuk latar gelap)</small>
                            </div>

                            <div class="mb-3">
                                <label class="form-label">Desktop Image</label>
                                <input type="file" class="form-control <?php $__errorArgs = ['form.image_desktop'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" wire:model.live="form.image_desktop">
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['form.image_desktop'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="invalid-feedback">
                                        <strong><?php echo e($message); ?></strong>
                                    </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </div>

                            <div class="mb-3">
                                <label class="form-label">Mobile Image</label>
                                <input type="file" class="form-control <?php $__errorArgs = ['form.image_mobile'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" wire:model.live="form.image_mobile">
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['form.image_mobile'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="invalid-feedback">
                                        <strong><?php echo e($message); ?></strong>
                                    </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </div>

                            <div class="row g-2 mb-3">
                                <div class="col">
                                    <label class="form-label">Start Date</label>
                                    <input type="date" class="form-control" wire:model.live="form.start_date">
                                </div>
                                <div class="col">
                                    <label class="form-label">End Date</label>
                                    <input type="date" class="form-control" wire:model.live="form.end_date">
                                </div>
                            </div>

                            <div class="row g-2">
                                <div class="col-4">
                                    <label class="form-label">Order</label>
                                    <input type="number" class="form-control" wire:model.live="form.order">
                                </div>
                                <div class="col-4">
                                    <label class="form-label">Active</label>
                                    <select class="form-select" wire:model.live="form.is_active">
                                        <option value="1">Yes</option>
                                        <option value="0">No</option>
                                    </select>
                                </div>
                                <div class="col-4">
                                    <label class="form-label">Page</label>
                                    <input type="text" class="form-control" wire:model.live="form.page">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="modal-footer">
                    <button class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button class="btn btn-primary" wire:click="store">Save</button>
                </div>
            </div>
        </div>
    </div>

    
    <div class="modal fade" id="modalPreview">
        <div class="modal-dialog modal-xl modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h1 class="modal-title fs-5" id="staticBackdropLabel">Preview Banner</h1>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body p-0 m-0">
                    <div class="d-block ratio ratio-21x9">
                        <img src="<?php echo e($form['image_path'] . $form['image_desktop']); ?>" alt="<?php echo e($form['title']); ?>"
                            class="img-fluid" style="object-position: center; object-fit:cover;">

                        <div class="d-flex align-items-center" style="justify-content: <?php echo e($form['text_position']); ?>">
                            <div class="col-7">
                                <div class="p-5 mt-4" style="color: <?php echo e($form['text_color']); ?>; text-align: <?php echo e($form['text_position']); ?>">

                                    <p class="mb-2 display-5 fw-bold"><?php echo e($form['title']); ?></p>
                                    <p class="fs-3 fw-light"><?php echo e($form['description']); ?></p>

                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($form['link']): ?>
                                    <a href="<?php echo e($form['link']); ?>" class="btn btn-lg px-4"
                                        style="color : <?php echo e($form['text_color']); ?>; border: 1px solid <?php echo e($form['text_color']); ?>;">
                                        <?php echo e($form['link_text']); ?>

                                    </a>
                                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>

    
    <div class="modal fade" id="modalDelete">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-body text-center py-5">
                    <i class="fad fa-exclamation-triangle fa-3x fa-fw"></i>
                    <p class="fs-2 fw-bold mb-0">Oops!</p>
                    <p>Kamu yakin ingin menghapus?</p>
                </div>
                <div class="d-flex align-items-center justify-content-center p-3 gap-3 border-top">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancle</button>
                    <button type="button" class="btn btn-danger" wire:click='deleteAction'>Delete</button>
                </div>
            </div>
        </div>
    </div>

    
    <?php echo $__env->make('components.modal.ModalDeleteComfrimed', ['title' => 'Data banner', 'count' => count($selected)], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

</div>

<?php $__env->startPush('script'); ?>
<?php $__env->stopPush(); ?><?php /**PATH C:\Users\safna\Projects\Laravel\aperonit\resources\views/content/content-banners-admin.blade.php ENDPATH**/ ?>