<?php $__env->startPush('head'); ?>
<?php $__env->stopPush(); ?>


<div class="ppt4 container-fluid">

    <div class="d-block rounded p-3 mb-3">
        <h4 class="card-title">Brand Product</h4>
        <h6 class="card-subtitle">Data table brand</h6>
    </div>

    <div class="d-block bg-theme-box rounded-3 overflow-hidden shadow-sm">

        
        <div class="d-flex justify-content-between align-items-center p-3">
            
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(count($selected) > 0): ?>
                <button class="btn btn-outline-danger" data-bs-toggle="modal" data-bs-target="#deleteModal">
                    <i class="fad fa-trash"></i> Hapus (<?php echo e(count($selected)); ?>)
                </button>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
            <button class="btn btn-outline-warning ms-auto" wire:click='addBrand()'>
                <i class="fa fa-plus"></i> New Category
            </button>
        </div>

        <div class="table-responsive">
            <table class="table table-borderless mb-3">
                <thead class="table-header">
                    <tr>
                        <th style="widht: 24px"></th>
                        <th width="32">
                            <input type="checkbox" wire:model.live="selectAll">
                        </th>
                        <th wire:click="sortBy('name')" style="cursor:pointer">
                            <div class="d-flex justify-content-between align-items-center">
                                <span>Name</span>
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($sortField === 'name'): ?>
                                <i class="fa fa-sort-<?php echo e($sortDirection); ?>"></i>
                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </div>
                        </th>
                        <th>Description</th>
                        <th wire:click="sortBy('is_active')" style="cursor:pointer">
                            <div class="d-flex justify-content-between align-items-center">
                                <span>Status</span>
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($sortField === 'is_active'): ?>
                                <i class="fa fa-sort-<?php echo e($sortDirection); ?>"></i>
                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </div>
                        </th>
                        <th wire:click="sortBy('created_at')" style="cursor:pointer">
                            <div class="d-flex justify-content-between align-items-center">
                                <span>Create Date</span>
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($sortField === 'created_at'): ?>
                                <i class="fa fa-sort-<?php echo e($sortDirection); ?>"></i>
                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </div>
                        </th>
                        
                        <th>Actions</th>
                        <th style="widht: 24px"></th>
    
                    </tr>
                </thead>
                <tbody class="table-transparent">
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__empty_1 = true; $__currentLoopData = $brand; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td style="widht: 24px"></td>
                        <td width="32">
                            <input type="checkbox" value="<?php echo e($cat->brand_id); ?>" wire:model.live="selected">
                        </td>
                        <td><?php echo e($cat->name); ?></td>
                        <td><?php echo e($cat->description); ?></td>
                        <td>
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($cat->is_active): ?>
                            <span class="badge bg-success">Active</span>
                            <?php else: ?>
                            <span class="badge bg-secondary">Inactive</span>
                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        </td>
                        <td><?php echo e($cat->created_at); ?></td>
                        <td>
                            <button class="btn btn-sm btn-info" wire:click="view(<?php echo e($cat->brand_id); ?>)">
                                <i class="fa fa-eye"></i>
                            </button>
                            <button class="btn btn-sm btn-warning" wire:click="edit(<?php echo e($cat->brand_id); ?>)">
                                <i class="fa fa-edit"></i>
                            </button>
                            <button class="btn btn-sm btn-danger" wire:click="delete(<?php echo e($cat->brand_id); ?>)">
                                <i class="fa fa-trash"></i>
                            </button>
                        </td>
                        <td style="widht: 24px"></td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="9" class="text-center">
                            <div class="border rounded py-5">
                                <i class="fad fa-box-open fa-3x fa-fw"></i>
                                <p class="fs-3 m-0">No brand found.</p>
                            </div>
                        </td>
                    </tr>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                </tbody>
            </table>
        </div>



        
        <div class="mb-3">
            <?php echo e($brand->links('components.utilities.paginate')); ?>

        </div>

        
    </div>
    
    
    <!-- Modal Create Category -->
    <div class="modal fade" id="CategoryModal" tabindex="-1" aria-hidden="true" wire:ignore.self>
        <div class="modal-dialog">
            <form wire:submit.prevent="submitedBrand" class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Category Form</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">

                    <!-- Name -->
                    <div class="mb-3">
                        <label class="form-label">Name</label>
                        <input type="text" class="form-control" wire:model.live="field.name">
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['field.name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </div>

                    <!-- Slug -->
                    <div class="mb-3">
                        <label class="form-label">Slug (optional)</label>
                        <input type="text" class="form-control" wire:model.live="field.slug">
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['field.slug'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </div>

                    <!-- type -->
                    <div class="mb-3">
                        <label class="form-label">Type (optional)</label>
                        <select class="form-select" name="type" id="type" wire:model.live="field.type">
                            <option value="product" selected>Product</option>
                            <option value="services">Services</option>
                        </select>
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['field.type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </div>

                    <!-- Description -->
                    <div class="mb-3">
                        <label class="form-label">Description</label>
                        <textarea class="form-control" wire:model.live="field.description"></textarea>
                    </div>
                    <div class="mb-3">
                        <label for="#" class="form-label">Upload Display Product</label>
                        <label for="images" class="border rounded ratio ratio-1x1 bs-secondary-bg-rgb mb-3"
                            style="cursor: pointer; background-color: #e9ecef">
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(!empty($field['logo'])): ?>
                            <div for="images" class="border rounded ratio ratio-1x1 image-upload"
                                style="background-image: url('<?php echo e($field['logo']->temporaryUrl()); ?>')">
                            </div>
                            <?php else: ?>
                            <div
                                class="d-flex flex-column align-self-center align-items-center justify-content-center">
                                <i class="fas fa-upload fa-3x fa-fw mb-3"></i>
                                <span class="fw-light">Upload Here...</span>
                            </div>
                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            <div class="justify-content-center align-items-center"
                                style="background-color: #e9ecef75;" wire:loading.flex wire:target="field.logo">
                                <span class="loader"></span>
                            </div>
                        </label>
                        <div>
                            <input type="file" id="images" wire:model="field.logo" name="field.logo"
                                class="form-control <?php $__errorArgs = ['field.logo'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                placeholder="Upload imagess here...">
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['field.logo'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="invalid-feedback">
                                <strong><?php echo e($message); ?></strong>
                            </span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        </div>
                    </div>

                    <!-- Status -->
                    <div class="mb-3 form-check">
                        <input type="checkbox" class="form-check-input" wire:model.live="field.is_active" value="1">
                        <label class="form-check-label">Active</label>
                    </div>
                </div>
                <div class="modal-footer py-2">
                    <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-outline-primary">Changes</button>
                </div>
            </form>
        </div>
    </div>

    <?php echo $__env->make('components.modal.ModalDeleteComfrimed', ['title' => 'Data Produk', 'count' => count($selected)], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
</div>


<?php $__env->startPush('script'); ?>

<?php $__env->stopPush(); ?><?php /**PATH C:\Users\safna\Projects\Laravel\aperonit\resources\views/products/productBrand/product-brand-admin.blade.php ENDPATH**/ ?>