<?php

use App\Http\Controllers\Auth\AuthHandlerController;
use App\Http\Livewire\Account\AccountPasswordAdmin;
use App\Http\Livewire\Account\Profile\ProfileAdmin;
use App\Http\Livewire\Auth\AuthAdminLogin;
use App\Http\Livewire\Content\ContentBannersAdmin;
use App\Http\Livewire\Information\Faq;
use App\Http\Livewire\Information\TermConditions;
use App\Http\Livewire\Pages\AdminDashboard;
use App\Http\Livewire\Products\ProductBrand\ProductBrandAdmin;
use App\Http\Livewire\Products\ProductCategory\ProductCategoryAdmin;
use App\Http\Livewire\Products\ProductServices\ProductServicesCreateAdmin;
use App\Http\Livewire\Products\ProductServices\ProductServicesDataAdmin;
use App\Http\Livewire\Products\ProductServices\ProductServicesEditAdmin;
use App\Http\Livewire\Setting\SettingAppearance;
use App\Http\Livewire\Setting\SettingMenuAdmin;
use Illuminate\Support\Facades\Route;

Route::get('/', AuthAdminLogin::class)->middleware('admin.auth.direct')->name('index');
Route::get('/admin/login', AuthAdminLogin::class)->middleware('admin.auth.direct')->name('admin.login');


Route::prefix('admin')->middleware('admin.auth')->group(function () {
    Route::get('/', AdminDashboard::class)->name('admin');
    Route::get('/dashboard', AdminDashboard::class)->name('admin.dashboard');

     // Account
    Route::get('/account/profile', ProfileAdmin::class)->name('admin.account.profile');
    Route::get('/account/password', AccountPasswordAdmin::class)->name('admin.account.password');

    
    // PRODUCT_SECTION
    Route::get('product/brand', ProductBrandAdmin::class)->name('admin.product.brand');
    Route::get('product/category', ProductCategoryAdmin::class)->name('admin.product.category');
    
    //PRODUCT_SERVICES
    Route::get('product/service', ProductServicesDataAdmin::class)->name('admin.product.services');
    Route::get('product/service/create', ProductServicesCreateAdmin::class)->name('admin.product.services.create');
    Route::get('product/service/edit/{id}', ProductServicesEditAdmin::class)->name('admin.product.services.edit');
    
    // PROJECT
    Route::get('project')->name('admin.project');
    
    // BANNER
    Route::get('/content/banner', ContentBannersAdmin::class)->name('admin.content.banner');

    // INFORMATION
    Route::get('admin/informasi/faq', Faq::class)->name('admin.information.faq');
    Route::get('admin/informasi/syarat-dan-ketentuan', TermConditions::class)->name('admin.information.termcondition');

    
    // SETTINMG_SECTION
    Route::get('setting/menu', SettingMenuAdmin::class)->name('admin.setting.menu');
    Route::get('setting/appearance', SettingAppearance::class)->name('admin.setting.appearance');

    Route::get('/logout', [AuthHandlerController::class, 'AdminLogout'])->name('admin.logout');
});
