@push('head')
@endpush


<div class="ppt4 container-fluid">
    {{-- Header --}}
    <div class="d-block rounded p-3 mb-3">
        <h4 class="card-title">Setting Menu</h4>
        <h6 class="card-subtitle">Menu dashboard peronit</h6>
    </div>

    {{-- Section Data --}}
    <div class="d-block bg-theme-box rounded-3 shadow-sm mb-3">
        {{-- Header --}}
        <div class="d-flex justify-content-between align-items-center p-3">
            <button class="btn btn-outline-warning" wire:click='addMenu()'>
                <i class="fa fa-plus"></i>
                <span class="d-none d-md-inline">New Menu</span>
            </button>
            {{-- Bulk Action --}}
            @if(count($selected) > 0)
            <button class="btn btn-outline-danger" data-bs-toggle="modal" data-bs-target="#deleteModal">
                <i class="fad fa-trash"></i> Hapus ({{ count($selected) }})
            </button>
            @endif
            <div class="d-flex gap-2 ms-auto">
                <div class="dropdown" id="menuDataFilter">
                    <button class="btn border-dark-subtle" type="button" data-bs-toggle="dropdown">
                        <i class="fad fa-filter fa-sm fa-fw"></i>
                    </button>
                    <div class="dropdown-menu shadow-sm m-0 p-0" style="width: 320px">
                        <div class="bg-secondary-subtle py-2 px-3">
                            <span class="fw-bold">Column Filter</span>
                        </div>
                        <div class="p-3">
                            <div class="d-flex align-items-center mb-3">
                                <small for="#pages" class="flex-fill">Page View</small>
                                <div class="">
                                    <select class="form-select form-select-sm" name="pages" id="pages" wire:model.live="pages">
                                        <option value="5">5</option>
                                        <option value="15">15</option>
                                        <option value="25">25</option>
                                        <option value="50">50</option>
                                        <option value="75">75</option>
                                        <option value="100">100</option>
                                    </select>
                                </div>
                            </div>
                            <div class="d-flex align-items-center">
                                <small for="#download" class="flex-fill">Download</small>
                                <div>
                                    <select class="form-select form-select-sm" name="download" id="download">
                                        <option value="dCSV">Download to CSV</option>
                                        <option value="dExcel">Download to Excel</option>
                                        <option value="dPrint">Print to printer</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="d-flex align-items-center">
                    <input type="text" wire:model.live="search" class="form-control pe-4"
                        placeholder="Search...">
                    <i class="fad fa-search fa-sm" style="margin-left: -32px"></i>
                </div>
            </div>
        </div>
        {{-- Tables --}}
        <div class="table-responsive">
            <table class="table table-borderless">
                <thead class="table-header">
                    <tr>
                        <th style="widht: 24px"></th>
                        <th>
                            <input type="checkbox" wire:model.live="selectAll">
                        </th>
                        <th wire:click="sortBy('order')" style="cursor:pointer">
                            <div class="d-flex justify-content-between align-items-center">
                                <span>#</span>
                                @if($sortField === 'order')
                                <i class="fa fa-sort-{{ $sortDirection }}"></i>
                                @endif
                            </div>
                        </th>
                        <th>Icon</th>
                        <th wire:click="sortBy('name')" style="cursor:pointer" class="text-nowrap">
                            <div class="d-flex justify-content-between align-items-center">
                                <span>Name</span>
                                @if($sortField === 'name')
                                <i class="fa fa-sort-{{ $sortDirection }}"></i>
                                @endif
                            </div>
                        </th>
                        <th>Type</th>
                        <th>URL</th>
                        <th wire:click="sortBy('parent_id')" style="cursor:pointer">
                            <div class="d-flex justify-content-between align-items-center">
                                <span>Parent</span>
                                @if($sortField === 'parent_id')
                                <i class="fa fa-sort-{{ $sortDirection }}"></i>
                                @endif
                            </div>
                        </th>
                        <th wire:click="sortBy('is_active')" style="cursor:pointer">
                            <div class="d-flex justify-content-between align-items-center">
                                <span>Status</span>
                                @if($sortField === 'is_active')
                                <i class="fa fa-sort-{{ $sortDirection }}"></i>
                                @endif
                            </div>
                        </th>
                        <th width="200" class="text-nowrap">Actions</th>
                        <th style="widht: 24px"></th>
                    </tr>
                </thead>
                <tbody class="table-transparent">
                    @forelse($menu->where('parent_id', null) as $cat)
                    <tr>
                        <td style="widht: 24px"></td>
                        <td>
                            <input type="checkbox" value="{{ $cat->menu_id }}" wire:model.live="selected">
                        </td>
                        <td>{{ $cat->sort_order }}</td>
                        <td><span class="{{ $cat->icon }}"></span></td>
                        <td class="text-nowrap">{{ $cat->name }}</td>
                        <td>{{ $cat->type }}</td>
                        <td>{{ $cat->url }}</td>
                        <td>{{ $cat->parent?->name ?? '-' }}</td>
                        <td>
                            @if($cat->is_active)
                            <span class="badge bg-success">Active</span>
                            @else
                            <span class="badge bg-secondary">Inactive</span>
                            @endif
                        </td>
                        <td class="text-nowrap">
                            <button class="btn btn-sm btn-outline-secondary border-0" wire:click="view({{ $cat->menu_id }})">
                                <i class="fa fa-eye"></i>
                            </button>
                            <button class="btn btn-sm btn-outline-secondary border-0" wire:click="edit({{ $cat->menu_id }})">
                                <i class="fa fa-edit"></i>
                            </button>
                            <button class="btn btn-sm btn-outline-secondary border-0" wire:click="delete({{ $cat->menu_id }})">
                                <i class="fa fa-trash"></i>
                            </button>
                            <button class="btn btn-sm btn-outline-secondary border-0" wire:click="addSubMenu({{ $cat->menu_id }})">
                                <i class="fa fa-plus"></i> Sub
                            </button>
                        </td>
                        <td style="widht: 24px"></td>
                    </tr>

                    {{-- Show Sub Categories --}}
                    @foreach($cat->children as $sub)
                    <tr>
                        <td style="widht: 24px"></td>
                        <td>
                            <input type="checkbox" value="{{ $sub->menu_id }}" wire:model.live="selected">
                        </td>
                        <td>{{ $sub->sort_order }}</td>
                        <td><span class="{{ $sub->icon }}"></span></td>
                        <td class="text-nowrap">— {{ $sub->name }}</td>
                        <td>{{ $sub->type }}</td>
                        <td>{{ $sub->url }}</td>
                        <td>{{ $sub->parent?->name }}</td>
                        <td>
                            @if($sub->is_active)
                            <span class="badge bg-success">Active</span>
                            @else
                            <span class="badge bg-secondary">Inactive</span>
                            @endif
                        </td>
                        <td class="text-nowrap">
                            <button class="btn btn-sm btn-outline-secondary border-0" wire:click="view({{ $sub->menu_id }})">
                                <i class="fa fa-eye"></i>
                            </button>
                            <button class="btn btn-sm btn-outline-secondary border-0" wire:click="edit({{ $sub->menu_id }})">
                                <i class="fa fa-edit"></i>
                            </button>
                            <button class="btn btn-sm btn-outline-secondary border-0" wire:click="delete({{ $sub->menu_id }})">
                                <i class="fa fa-trash"></i>
                            </button>
                            <button class="btn btn-sm btn-outline-secondary border-0" wire:click="addChildMenu({{ $sub->menu_id }})">
                                <i class="fa fa-plus"></i> Child
                            </button>
                        </td>
                        <td style="widht: 24px"></td>
                    </tr>

                    {{-- Show Child Categories --}}
                    @foreach($sub->children as $child)
                    <tr>
                        <td style="widht: 24px"></td>
                        <td>
                            <input type="checkbox" value="{{ $child->menu_id }}" wire:model.live="selected">
                        </td>
                        <td>{{ $child->sort_order }}</td>
                        <td><span class="{{ $child->icon }}"></span></td>
                        <td class="text-nowrape">—— {{ $child->name }}</td>
                        <td>{{ $child->type }}</td>
                        <td>{{ $child->url }}</td>
                        <td>{{ $child->parent?->name }}</td>
                        <td>
                            @if($child->is_active)
                            <span class="badge bg-success">Active</span>
                            @else
                            <span class="badge bg-secondary">Inactive</span>
                            @endif
                        </td>
                        <td class="text-nowrap">
                            <button class="btn btn-sm btn-outline-secondary border-0" wire:click="view({{ $child->menu_id }})">
                                <i class="fa fa-eye"></i>
                            </button>
                            <button class="btn btn-sm btn-outline-secondary border-0" wire:click="edit({{ $child->menu_id }})">
                                <i class="fa fa-edit"></i>
                            </button>
                            <button class="btn btn-sm btn-outline-secondary border-0" wire:click="delete({{ $child->menu_id }})">
                                <i class="fa fa-trash"></i>
                            </button>
                        </td>
                        <td style="widht: 24px"></td>

                    </tr>
                    @endforeach

                    @endforeach

                    @empty
                    <tr>
                        <td colspan="10" class="text-center">
                            <div class="border rounded py-5">
                                <i class="fad fa-box-open fa-3x fa-fw"></i>
                                <p class="fs-3 m-0">No categories found.</p>
                            </div>
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>

    {{-- Pagination --}}
     {{ $menu->links('components.utilities.paginate') }}


    <!-- Section Modal -->
    <div class="modal fade" id="MenuModal" tabindex="-1" aria-hidden="true" wire:ignore.self>
        <div class="modal-dialog">
            <form wire:submit.prevent="submitedMenu" class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Menu Form</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    {{-- Type --}}
                    <div class="mb-3">
                        <label class="form-label">Type {{$field['type']}}</label>
                        <select class="form-select" wire:model.live="field.type">
                            <option value="item">Item</option>
                            <option value="separator">Separator</option>
                        </select>
                        @error('field.type') <span class="text-danger">{{ $message }}</span> @enderror
                    </div>
                    @if($field['type'] == 'item')
                    <!-- Name -->
                    <div class="mb-3">
                        <label class="form-label">Name</label>
                        <input type="text" class="form-control" wire:model.live="field.name">
                        @error('field.name') <span class="text-danger">{{ $message }}</span> @enderror
                    </div>
                    <!-- icon -->
                    <div class="mb-3">
                        <label class="form-label">Icon (FA Class)</label>
                        <input type="text" class="form-control" wire:model.live="field.icon">
                        @error('field.icon') <span class="text-danger">{{ $message }}</span> @enderror
                    </div>
                    <!-- URL -->
                    <div class="mb-3">
                        <label class="form-label">URL</label>
                        <input type="text" class="form-control" wire:model.live="field.url">
                        @error('field.url') <span class="text-danger">{{ $message }}</span> @enderror
                    </div>
                    <!-- Route -->
                    <div class="mb-3">
                        <label class="form-label">Route Name</label>
                        <input type="text" class="form-control" wire:model.live="field.route">
                        @error('field.route') <span class="text-danger">{{ $message }}</span> @enderror
                    </div>
                    @endif
                    <!-- Parent Category -->
                    <div class="mb-3">
                        <label class="form-label">Parent Category</label>
                        <select class="form-select" wire:model.live="field.parent_id">
                            <option value="">-- No Parent (Main Category) --</option>
                            @foreach($allMenu as $cat)
                            <option value="{{ $cat->menu_id }}">{{ $cat->name }}</option>
                            @endforeach
                        </select>
                        @error('field.parent_id') <span class="text-danger">{{ $message }}</span>
                        @enderror
                    </div>
                    {{-- Sort Order --}}
                    <div class="mb-3">
                        <label class="form-label">Sort Order</label>
                        <input type="number" class="form-control" wire:model.live="field.sort_order">
                        @error('field.sort_order') <span class="text-danger">{{ $message }}</span> @enderror
                    </div>
                    <!-- Status -->
                    <div class="mb-3 form-check">
                        <input type="checkbox" class="form-check-input" wire:model.live="field.is_active" value="1">
                        <label class="form-check-label">Active</label>
                    </div>
                </div>
                <div class="modal-footer py-2">
                    <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-outline-primary">Changes</button>
                </div>
            </form>
        </div>
    </div>


    @include('components.modal.ModalDeleteComfrimed', ['title' => 'Data Produk', 'count' => count($selected)])
</div>


@push('script')

@endpush