@push('head')
@endpush

<div class="container-fluid ppt5">
    <div class="d-flex align-items-center p-3 mb-3">
        <div class="text-content">
            <h2 class="m-0">Table Modul</h2>
            <p class="mb-0 fw-light">Form modul table</p>
        </div>
        <button class="btn btn-outline-warning">
            <i class="fad fa-plus fa-sm fa-fw"></i>
            <span>Tambah Data</span>
        </button>
    </div>

    {{-- Section Data --}}
    <div class="d-block bg-white rounded-3 overflow-hidden shadow-sm mb-3">

        {{-- Header --}}
        <div class="d-flex justify-content-between align-items-center p-3">
            @if(count($selected) > 0)
            <button class="btn btn-outline-danger" data-bs-toggle="modal" data-bs-target="#deleteModal">
                <i class="fad fa-trash"></i> Hapus ({{ count($selected) }})
            </button>
            @endif
            <div class="d-flex gap-2 ms-auto">
                <div class="dropdown">
                    <button class="btn border-dark-subtle" type="button" data-bs-toggle="dropdown">
                        <i class="fad fa-filter fa-sm fa-fw"></i>
                    </button>
                    <div class="dropdown-menu shadow-sm m-0 p-0" style="width: 320px">
                        <div class="bg-secondary-subtle py-2 px-3">
                            <span class="fw-bold">Column Filter</span>
                        </div>
                        <div class="p-3">
                            <div class="d-flex align-items-center mb-3">
                                <small class="flex-fill">Page View</small>
                                <div>
                                    <select class="form-select form-select-sm" name="pages" id="pages" wire:model.live="pages">
                                        <option value="5">5</option>
                                        <option value="15">15</option>
                                        <option value="25">25</option>
                                        <option value="50">50</option>
                                        <option value="75">75</option>
                                        <option value="100">100</option>
                                    </select>
                                </div>
                            </div>
                            <div class="d-flex align-items-center">
                                <small class="flex-fill">Download</small>
                                <div>
                                    <select class="form-select form-select-sm" name="download" id="download">
                                        <option value="dCSV">Download to CSV</option>
                                        <option value="dExcel">Download to Excel</option>
                                        <option value="dPrint">Print to printer</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="d-flex align-items-center">
                    <input type="text" wire:model.live="search" class="form-control pe-4" placeholder="Search...">
                    <i class="fad fa-search fa-sm" style="margin-left: -32px"></i>
                </div>
            </div>
        </div>

        {{-- Tables --}}
        <div class="table-responsive">
            <table class="table table-borderless">
                <thead class="table-light">
                    <tr>
                        <th style="width: 24px"></th>
                        <th><input type="checkbox" wire:model.live="selectAll"></th>
                        <th wire:click="sortBy('title')" style="cursor:pointer">
                            <div class="d-flex justify-content-between align-items-center">
                                <span>Title</span>
                                @if($sortField === 'title')
                                <i class="fa fa-sort-{{ $sortDirection }}"></i>
                                @endif
                            </div>
                        </th>
                        <th width="200" class="text-nowrap">Actions</th>
                        <th style="width: 24px"></th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($data as $index => $item)
                    <tr>
                        <td style="width: 24px"></td>
                        <td><input type="checkbox" value="{{ $item->id }}" wire:model.live="selected"></td>
                        <td>{{ $item->title }}</td>

                        <td class="text-nowrap">
                            <button class="btn btn-sm btn-outline-secondary border-0" wire:click="view({{ $item->menu_id }})"><i class="fa fa-eye"></i></button>
                            <button class="btn btn-sm btn-outline-secondary border-0" wire:click="edit({{ $item->menu_id }})"><i class="fa fa-edit"></i></button>
                            <button class="btn btn-sm btn-outline-secondary border-0" wire:click="delete({{ $item->menu_id }})"><i class="fa fa-trash"></i></button>
                        </td>
                        <td style="width: 24px"></td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="10" class="text-center">
                            <div class="border rounded py-5">
                                <i class="fad fa-box-open fa-3x fa-fw"></i>
                                <p class="fs-3 m-0">No categories found.</p>
                            </div>
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>

    {{-- Pagination --}}
    <div class="d-flex align-items-center bg-white rounded-3 shadow-sm mb-3 p-3">
        <p class="fw-bold m-0">Page {{ $data->currentPage() }} of {{ $data->lastPage() }}</p>
        <div class="ms-auto">{{ $data->links('admin.layouts.paginate') }}</div>
    </div>
</div>

@push('script')
@endpush