<div>

    <div class="row g-4">

        <div class="col-12 col-md-7">
            <div class="d-block bg-theme-box rounded shadow-sm h-100 p-3">
                <div class="mb-3">
                    <label for="#" class="form-label">SKU</label>
                    <input type="sku" name="sku" wire:model.live='product.sku'
                        class="form-control disabled @error('product.sku') is-invalid @enderror" readonly disabled>
                    @error('product.sku')
                    <span class="invalid-feedback text-capitalize">
                        <strong>{{ $message }}</strong>
                    </span>
                    @enderror
                </div>
                <div class="mb-3">
                    <label for="#" class="form-label">Nama Product</label>
                    <input type="name" name="name" wire:model.live='product.name'
                        class="form-control  @error('product.name') is-invalid @enderror">
                    @error('product.name')
                    <span class="invalid-feedback text-capitalize">
                        <strong>{{ $message }}</strong>
                    </span>
                    @enderror
                </div>
                <div class="mb-3">
                    <label for="#" class="form-label">Harga Product</label>
                    <div class="input-group">
                        <span class="input-group-text" id="basic-addon1">Rp.</span>
                        <input type="text" name="price" wire:model.live='priceFormatted' wire:input="formatPrice"
                            class="form-control  @error('product.price') is-invalid @enderror">
                    </div>
                    @error('product.price')
                    <span class="d-block invalid-feedback text-capitalize">
                        <strong>{{ $message }}</strong>
                    </span>
                    @enderror
                </div>
                <div class="row mb-3">
                    <div class="col">
                        <label for="brand" class="form-label">Brand Product</label>
                        <select name="brand" id="brand" class="form-select" wire:model.live="product.brand_id">
                            <option value="">Pilih brand</option>
                            @foreach ($brands as $item)
                            <option value="{{$item->brand_id}}">{{$item->name}}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col">
                        <label for="category" class="form-label">Category Product</label>
                        <select name="category_id" class="form-select" wire:model.live="product.category_id">
                            <option value="">Pilih Kategori</option>
                            @foreach ($category as $parent)
                            <option value="{{ $parent->category_id }}">{{ $parent->name }}</option>
                                @foreach ($parent->children as $child)
                                <option value="{{ $child->category_id }}">-- {{ $child->name }}</option>
                                    @foreach ($child->children as $subchild)
                                    <option value="{{ $subchild->category_id }}">---- {{ $subchild->name }}</option>
                                    @endforeach
                                @endforeach
                            @endforeach
                        </select>
                        @error('product.category_id')
                        <span class="invalid-feedback text-capitalize">
                            <strong>{{ $message }}</strong>
                        </span>
                        @enderror
                    </div>
                </div>
                <div class="mb-3">
                    <label for="#" class="form-label">Deskripsi Product</label>
                    <textarea name="description_short" id="description_short"
                        wire:model.live='product.description_short' rows="4"
                        class="form-control  @error('product.description_short') is-invalid @enderror"></textarea>
                    @error('product.description_short')
                    <span class="invalid-feedback text-capitalize">
                        <strong>{{ $message }}</strong>
                    </span>
                    @enderror
                </div>
                <div>
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" id="checkIsActive" wire:model.live="product.is_active">
                        <label class="form-check-label" for="checkIsActive">
                            Active Product
                        </label>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-12 col-md-5 col-lg-5">
            <div class="d-block bg-theme-box rounded shadow-sm h-100 p-3">
                <div class="mb-3">
                    <label for="#" class="form-label">Upload Display Product</label>
                    <label for="images" class="border rounded ratio ratio-1x1 bs-secondary-bg-rgb"
                        style="cursor: pointer; background-color: #e9ecef">
                        @if (is_object($product['images']) && method_exists($product['images'], 'temporaryUrl'))
                        <div for="images" class="border rounded ratio ratio-1x1 image-upload"
                            style="background-image: url('{{ $product['images']->temporaryUrl() }}')">
                        </div>
                        @elseif($product['images'])
                        <div for="images" class="border rounded ratio ratio-1x1 image-upload"
                            style="background-image: url('/{{ $product['images']->path }}')">
                        </div>
                        @else
                        <div class="d-flex flex-column align-self-center align-items-center justify-content-center">
                            <i class="fas fa-upload fa-3x fa-fw mb-3"></i>
                            <span class="fw-light">Upload Here...</span>
                        </div>
                        @endif
                        <div class="justify-content-center align-items-center" style="background-color: #e9ecef75;"
                            wire:loading.flex wire:target="product.images">
                            <span class="loader"></span>
                        </div>
                    </label>
                </div>
                <div class="mb-3">
                    <input type="file" id="images" wire:model.live="product.images" name="images"
                        class="form-control @error('product.images') is-invalid @enderror"
                        placeholder="Upload imagess here...">
                    @error('product.images')
                    <span class="invalid-feedback">
                        <strong>{{ $message }}</strong>
                    </span>
                    @enderror
                </div>
            </div>
        </div>

        <div class="col-12">
            <div class="d-block rounded bg-theme-box">
                <div class="d-flex align-items-center border-bottom p-3">
                    <span class="fw-bold me-auto">Detail Description</span>
                    <button class="btn btn-sm btn-outline-success" type="button" wire:click="addInput">
                        <i class="fas fa-plus fa-sm fa-fw"></i>
                    </button>
                </div>
                <div class="p-3">
                    @foreach ($description_list as $index => $item)
                    <div class="d-flex gap-2 mb-2">
                        <input type="text" wire:model.live="description_list.{{$index}}" name="description_list[]"
                            class="form-control" value="{{ $item }}" placeholder="List Description...">
                        <button class="btn btn-danger" type="button" wire:click="delInput({{ $index }})">
                            <i class="fas fa-trash fa-xs fa-fw"></i>
                        </button>
                    </div>
                    @endforeach
                </div>
            </div>
        </div>

        <div class="col-12">
            {{-- SEO Meta --}}
            @include('components.forms.SeoMetaForm')
        </div>

        <div class="col-12">
            <div class="d-block rounded bg-theme-box p-3">
                <button type="submit" class="btn btn-outline-success" name="save">Save Product</button>
            </div>
        </div>
    </div>


</div>