@push('head')
@endpush

<div class="ppt4 container-fluid">
    <div class="row g-3">

        <div class="col-12">
            <div class="d-block rounded p-3">
                <h4 class="card-title">Products</h4>
                <h6 class="card-subtitle">List of all Products</h6>
            </div>
        </div>

        <div class="col-12">
            <div class="d-block rounded bg-theme-box">
                {{-- Filter & Search --}}
                <div class="d-flex gap-3 p-3">
                    @if(count($selected) > 0)
                    <button class="btn btn-outline-danger" data-bs-toggle="modal" data-bs-target="#deleteModal">
                        <i class="fad fa-trash"></i> ({{ count($selected) }})
                    </button>
                    @endif
                    <div class="d-flex align-items-center ms-auto">
                        <input type="text" wire:model.live="search" class="form-control pe-4"
                            placeholder="Search Product...">
                        <i class="fad fa-search fa-sm" style="margin-left: -32px"></i>
                    </div>
                    <div class="dropdown" id="productDataFilter">
                        <button class="btn border-dark-subtle" type="button" data-bs-toggle="dropdown">
                            <i class="fad fa-filter fa-sm fa-fw"></i>
                        </button>
                        <div class="dropdown-menu shadow-sm m-0 p-0" style="width: 320px">
                            <div class="bg-secondary-subtle py-2 px-3">
                                <span class="fw-bold">Column Filter</span>
                            </div>
                            <div class="p-3">
                                <div class="d-flex align-items-center mb-3">
                                    <small for="#pages" class="flex-fill">Page View</small>
                                    <div class="">
                                        <select class="form-select form-select-sm" name="pages" id="pages" wire:model.live="pages">
                                            <option value="5">5</option>
                                            <option value="15">15</option>
                                            <option value="25">25</option>
                                            <option value="50">50</option>
                                            <option value="75">75</option>
                                            <option value="100">100</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="d-flex align-items-center">
                                    <small for="#download" class="flex-fill">Download</small>
                                    <div>
                                        <select class="form-select form-select-sm" name="download" id="download">
                                            <option value="dCSV">Download to CSV</option>
                                            <option value="dExcel">Download to Excel</option>
                                            <option value="dPrint">Print to printer</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <a href="{{ route('admin.product.services.create') }}" class="btn btn-outline-secondary">
                        <i class="fas fa-plus fa-sm"></i>
                    </a>
                </div>

                {{-- Table --}}
                <div class="table-responsive" style="min-height: 55vh">
                    <table class="table table-borderless align-middle">
                        <thead class="table-header">
                            <tr class="text-capitalize">
                                <th style="width: 24px"></th>
                                <th style="width: 48px">
                                    <input type="checkbox" wire:model.live="selectAll">
                                </th>
                                <th wire:click="sortBy('name')" style="cursor:pointer">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <span>Name</span>
                                        @if($sortField === 'name')
                                        <i class="fa fa-sort-{{ $sortDirection }}"></i>
                                        @endif
                                    </div>
                                </th>
                                <th wire:click="sortBy('price')" style="cursor:pointer">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <span>Price</span>
                                        @if($sortField === 'price')
                                        <i class="fa fa-sort-{{ $sortDirection }}"></i>
                                        @endif
                                    </div>
                                </th>
                                <th wire:click="sortBy('category_id')" style="cursor:pointer">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <span>category</span>
                                        @if($sortField === 'category_id')
                                        <i class="fa fa-sort-{{ $sortDirection }}"></i>
                                        @endif
                                    </div>
                                </th>
                                <th wire:click="sortBy('is_active')" style="corsor:pointer">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <span>status</span>
                                        @if($sortField === 'is_active')
                                        <i class="fa fa-sort-{{ $sortDirection }}"></i>
                                        @endif
                                    </div>
                                </th>
                                <th wire:click="sortBy('created_at')" style="corsor:pointer">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <span>Create_Date</span>
                                        @if($sortField === 'created_at')
                                        <i class="fa fa-sort-{{ $sortDirection }}"></i>
                                        @endif
                                    </div>
                                </th>
                                <th width="120">Actions</th>
                                <th style="width: 24px"></th>
                            </tr>
                        </thead>
                        <tbody class="table-transparent">
                            @forelse($products as $product)
                            <tr>
                                <td style="widht: 24px"></td>
                                <td style="width: 48px">
                                    <input type="checkbox" wire:model.live="selected"
                                        value="{{ $product->product_id }}">
                                </td>
                                <td>{{ $product->name }}</td>
                                <td>Rp. {{ number_format($product->price, 2) }}</td>
                                <td>{{ $product->category->name }}</td>
                                <td>
                                    @if($product->is_active==true)
                                    <span class="badge rounded-pill text-bg-success">Active</span>
                                    @else
                                    <span class="badge rounded-pill text-bg-secondary">Deactive</span>
                                    @endif
                                </td>
                                <td>{{ $product->created_at }}</td>
                                <td class="text-nowrap">
                                    <div class="btn-group gap-2">
                                        <button class="btn btn-sm btn-outline-primary">
                                            <i class="fad fa-eye"></i>
                                        </button>
                                        <a href="{{ route('admin.product.services.edit', ['id' => $product->product_id]) }}"
                                            class="btn btn-sm btn-outline-warning">
                                            <i class="fad fa-edit"></i>
                                        </a>
                                        <button class="btn btn-sm btn-outline-danger">
                                            <i class="fad fa-trash"></i>
                                        </button>
                                    </div>
                                </td>
                                <td style="widht: 24px"></td>
                            </tr>
                            @empty
                            <tr>
                                <td colspan="9" class="text-center">
                                    <div class="border rounded py-5">
                                        <i class="fad fa-box-open fa-3x fa-fw"></i>
                                        <p class="fs-4">No products found.</p>
                                    </div>
                                </td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <div class="col-12">
            {{-- Pagination --}}
            {{ $products->links('components.utilities.paginate') }}
        </div>

    </div>

    @include('components.modal.ModalDeleteComfrimed',  ['title' => 'Data Produk', 'count' => count($selected)])
</div>

@push('script') @endpush