@push('head')
@endpush


<div class="ppt4 container-fluid">

    <div class="d-block rounded p-3 mb-3">
        <h4 class="card-title">Category</h4>
        <h6 class="card-subtitle">Data table category</h6>
    </div>

    <div class="d-block bg-theme-box rounded-3 overflow-hidden shadow-sm">

        {{-- Header --}}
        <div class="d-flex justify-content-between align-items-center p-3">
            {{-- Bulk Action --}}
            @if(count($selected) > 0)
                <button class="btn btn-outline-danger" data-bs-toggle="modal" data-bs-target="#deleteModal">
                    <i class="fad fa-trash"></i> Hapus ({{ count($selected) }})
                </button>
            @endif
            <button class="btn btn-outline-warning ms-auto" wire:click='addCategory()'>
                <i class="fa fa-plus"></i> New Category
            </button>
        </div>

        <div class="table-responsive">
            <table class="table table-borderless mb-3">
                <thead class="table-header">
                    <tr>
                        <th style="widht: 24px"></th>
    
                        <th>
                            <input type="checkbox" wire:model.live="selectAll">
                        </th>
                        <th wire:click="sortBy('name')" style="cursor:pointer">
                            <div class="d-flex justify-content-between align-items-center">
                                <span>Name</span>
                                @if($sortField === 'name')
                                <i class="fa fa-sort-{{ $sortDirection }}"></i>
                                @endif
                            </div>
                        </th>
                        <th>Description</th>
                        <th wire:click="sortBy('parent_id')" style="cursor:pointer">
                            <div class="d-flex justify-content-between align-items-center">
                                <span>Parent</span>
                                @if($sortField === 'parent_id')
                                <i class="fa fa-sort-{{ $sortDirection }}"></i>
                                @endif
                            </div>
                        </th>
                        <th wire:click="sortBy('is_active')" style="cursor:pointer">
                            <div class="d-flex justify-content-between align-items-center">
                                <span>Status</span>
                                @if($sortField === 'is_active')
                                <i class="fa fa-sort-{{ $sortDirection }}"></i>
                                @endif
                            </div>
                        </th>
                        <th width="200">Actions</th>
                        <th style="widht: 24px"></th>
    
                    </tr>
                </thead>
                <tbody class="table-transparent">
                    @forelse($categories->where('parent_id', null) as $cat)
                    <tr>
                        <td style="widht: 24px"></td>
                        <td>
                            <input type="checkbox" value="{{ $cat->category_id }}" wire:model.live="selected">
                        </td>
                        <td>{{ $cat->name }}</td>
                        <td>{{ $cat->description }}</td>
                        <td>{{ $cat->parent?->name ?? '-' }}</td>
                        <td>
                            @if($cat->is_active)
                            <span class="badge bg-success">Active</span>
                            @else
                            <span class="badge bg-secondary">Inactive</span>
                            @endif
                        </td>
                        <td>
                            <button class="btn btn-sm btn-info" wire:click="view({{ $cat->category_id }})">
                                <i class="fa fa-eye"></i>
                            </button>
                            <button class="btn btn-sm btn-warning" wire:click="edit({{ $cat->category_id }})">
                                <i class="fa fa-edit"></i>
                            </button>
                            <button class="btn btn-sm btn-danger" wire:click="delete({{ $cat->category_id }})">
                                <i class="fa fa-trash"></i>
                            </button>
                            <button class="btn btn-sm btn-success" wire:click="addSubCategory({{ $cat->category_id }})">
                                <i class="fa fa-plus"></i> Sub
                            </button>
                        </td>
                        <td style="widht: 24px"></td>
                    </tr>
    
                        {{-- Show Sub Categories --}}
                        @foreach($cat->children as $sub)
                        <tr>
                            <td style="widht: 24px"></td>
                            <td></td>
                            <td>— {{ $sub->name }}</td>
                            <td>{{ $sub->description }}</td>
                            <td>{{ $sub->parent?->name }}</td>
                            <td>
                                @if($sub->is_active)
                                <span class="badge bg-success">Active</span>
                                @else
                                <span class="badge bg-secondary">Inactive</span>
                                @endif
                            </td>
                            <td>
                                <button class="btn btn-sm btn-info" wire:click="view({{ $sub->category_id }})">
                                    <i class="fa fa-eye"></i>
                                </button>
                                <button class="btn btn-sm btn-warning" wire:click="edit({{ $sub->category_id }})">
                                    <i class="fa fa-edit"></i>
                                </button>
                                <button class="btn btn-sm btn-danger" wire:click="delete({{ $sub->category_id }})">
                                    <i class="fa fa-trash"></i>
                                </button>
                                <button class="btn btn-sm btn-success" wire:click="addChildCategory({{ $sub->category_id }})">
                                    <i class="fa fa-plus"></i> Child
                                </button>
                            </td>
                            <td style="widht: 24px"></td>
    
                        </tr>
                            {{-- Show Child Categories --}}
                            @foreach($sub->children as $child)
                            <tr>
                                <td style="widht: 24px"></td>
                                <td></td>
                                <td>—— {{ $child->name }}</td>
                                <td>{{ $child->description }}</td>
                                <td>{{ $child->parent?->name }}</td>
                                <td>
                                    @if($child->is_active)
                                    <span class="badge bg-success">Active</span>
                                    @else
                                    <span class="badge bg-secondary">Inactive</span>
                                    @endif
                                </td>
                                <td>
                                    <button class="btn btn-sm btn-info" wire:click="view({{ $child->category_id }})">
                                        <i class="fa fa-eye"></i>
                                    </button>
                                    <button class="btn btn-sm btn-warning" wire:click="edit({{ $child->category_id }})">
                                        <i class="fa fa-edit"></i>
                                    </button>
                                    <button class="btn btn-sm btn-danger" wire:click="delete({{ $child->category_id }})">
                                        <i class="fa fa-trash"></i>
                                    </button>
                                </td>
                                <td style="widht: 24px"></td>
    
                            </tr>
                            @endforeach
                        @endforeach
    
                    @empty
                    <tr>
                        <td colspan="9" class="text-center">
                            <div class="border rounded py-5">
                                <i class="fad fa-box-open fa-3x fa-fw"></i>
                                <p class="fs-3 m-0">No categories found.</p>
                            </div>
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>



        {{-- Pagination --}}
        <div class="mb-3">
            {{ $categories->links('components.utilities.paginate') }}
        </div>

        
    </div>
    
    
    <!-- Modal Create Category -->
    <div class="modal fade" id="CategoryModal" tabindex="-1" aria-hidden="true" wire:ignore.self>
        <div class="modal-dialog">
            <form wire:submit.prevent="submitedCategory" class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Category Form</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">

                    <!-- Name -->
                    <div class="mb-3">
                        <label class="form-label">Name</label>
                        <input type="text" class="form-control" wire:model.live="categoryField.name">
                        @error('categoryField.name') <span class="text-danger">{{ $message }}</span> @enderror
                    </div>

                    <!-- Slug -->
                    <div class="mb-3">
                        <label class="form-label">Slug (optional)</label>
                        <input type="text" class="form-control" wire:model.live="categoryField.slug">
                        @error('categoryField.slug') <span class="text-danger">{{ $message }}</span> @enderror
                    </div>

                    <!-- Parent Category -->
                    <div class="mb-3">
                        <label class="form-label">Parent Category</label>
                        <select class="form-select" wire:model.live="categoryField.parent_id">
                            <option value="">-- No Parent (Main Category) --</option>
                            @foreach($allCategories as $cat)
                            <option value="{{ $cat->category_id }}">{{ $cat->name }}</option>
                            @endforeach
                        </select>
                        @error('categoryField.parent_id') <span class="text-danger">{{ $message }}</span>
                        @enderror
                    </div>

                    <!-- type -->
                    <div class="mb-3">
                        <label class="form-label">Type (optional)</label>
                        <select class="form-select" name="type" id="type" wire:model.live="categoryField.type">
                            <option value="product" selected>Product</option>
                            <option value="services">Services</option>
                        </select>
                        @error('field.type') <span class="text-danger">{{ $message }}</span> @enderror
                    </div>

                    <!-- Description -->
                    <div class="mb-3">
                        <label class="form-label">Description</label>
                        <textarea class="form-control" wire:model.live="categoryField.description"></textarea>
                    </div>

                    <!-- Status -->
                    <div class="mb-3 form-check">
                        <input type="checkbox" class="form-check-input" wire:model.live="categoryField.is_active"
                            value="1">
                        <label class="form-check-label">Active</label>
                    </div>
                </div>
                <div class="modal-footer py-2">
                    <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-outline-primary">Changes</button>
                </div>
            </form>
        </div>
    </div>

    @include('components.modal.ModalDeleteComfrimed',  ['title' => 'Data Produk', 'count' => count($selected)])
</div>


@push('script')

@endpush