@push('head')
@endpush


<div class="ppt4 container-fluid">

    <div class="d-block rounded p-3 mb-3">
        <h4 class="card-title">Brand Product</h4>
        <h6 class="card-subtitle">Data table brand</h6>
    </div>

    <div class="d-block bg-theme-box rounded-3 overflow-hidden shadow-sm">

        {{-- Header --}}
        <div class="d-flex justify-content-between align-items-center p-3">
            {{-- Bulk Action --}}
            @if(count($selected) > 0)
                <button class="btn btn-outline-danger" data-bs-toggle="modal" data-bs-target="#deleteModal">
                    <i class="fad fa-trash"></i> Hapus ({{ count($selected) }})
                </button>
            @endif
            <button class="btn btn-outline-warning ms-auto" wire:click='addBrand()'>
                <i class="fa fa-plus"></i> New Category
            </button>
        </div>

        <div class="table-responsive">
            <table class="table table-borderless mb-3">
                <thead class="table-header">
                    <tr>
                        <th style="widht: 24px"></th>
                        <th width="32">
                            <input type="checkbox" wire:model.live="selectAll">
                        </th>
                        <th wire:click="sortBy('name')" style="cursor:pointer">
                            <div class="d-flex justify-content-between align-items-center">
                                <span>Name</span>
                                @if($sortField === 'name')
                                <i class="fa fa-sort-{{ $sortDirection }}"></i>
                                @endif
                            </div>
                        </th>
                        <th>Description</th>
                        <th wire:click="sortBy('is_active')" style="cursor:pointer">
                            <div class="d-flex justify-content-between align-items-center">
                                <span>Status</span>
                                @if($sortField === 'is_active')
                                <i class="fa fa-sort-{{ $sortDirection }}"></i>
                                @endif
                            </div>
                        </th>
                        <th wire:click="sortBy('created_at')" style="cursor:pointer">
                            <div class="d-flex justify-content-between align-items-center">
                                <span>Create Date</span>
                                @if($sortField === 'created_at')
                                <i class="fa fa-sort-{{ $sortDirection }}"></i>
                                @endif
                            </div>
                        </th>
                        
                        <th>Actions</th>
                        <th style="widht: 24px"></th>
    
                    </tr>
                </thead>
                <tbody class="table-transparent">
                    @forelse($brand as $cat)
                    <tr>
                        <td style="widht: 24px"></td>
                        <td width="32">
                            <input type="checkbox" value="{{ $cat->brand_id }}" wire:model.live="selected">
                        </td>
                        <td>{{ $cat->name }}</td>
                        <td>{{ $cat->description }}</td>
                        <td>
                            @if($cat->is_active)
                            <span class="badge bg-success">Active</span>
                            @else
                            <span class="badge bg-secondary">Inactive</span>
                            @endif
                        </td>
                        <td>{{ $cat->created_at }}</td>
                        <td>
                            <button class="btn btn-sm btn-info" wire:click="view({{ $cat->brand_id }})">
                                <i class="fa fa-eye"></i>
                            </button>
                            <button class="btn btn-sm btn-warning" wire:click="edit({{ $cat->brand_id }})">
                                <i class="fa fa-edit"></i>
                            </button>
                            <button class="btn btn-sm btn-danger" wire:click="delete({{ $cat->brand_id }})">
                                <i class="fa fa-trash"></i>
                            </button>
                        </td>
                        <td style="widht: 24px"></td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="9" class="text-center">
                            <div class="border rounded py-5">
                                <i class="fad fa-box-open fa-3x fa-fw"></i>
                                <p class="fs-3 m-0">No brand found.</p>
                            </div>
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>



        {{-- Pagination --}}
        <div class="mb-3">
            {{ $brand->links('components.utilities.paginate') }}
        </div>

        
    </div>
    
    
    <!-- Modal Create Category -->
    <div class="modal fade" id="CategoryModal" tabindex="-1" aria-hidden="true" wire:ignore.self>
        <div class="modal-dialog">
            <form wire:submit.prevent="submitedBrand" class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Category Form</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">

                    <!-- Name -->
                    <div class="mb-3">
                        <label class="form-label">Name</label>
                        <input type="text" class="form-control" wire:model.live="field.name">
                        @error('field.name') <span class="text-danger">{{ $message }}</span> @enderror
                    </div>

                    <!-- Slug -->
                    <div class="mb-3">
                        <label class="form-label">Slug (optional)</label>
                        <input type="text" class="form-control" wire:model.live="field.slug">
                        @error('field.slug') <span class="text-danger">{{ $message }}</span> @enderror
                    </div>

                    <!-- type -->
                    <div class="mb-3">
                        <label class="form-label">Type (optional)</label>
                        <select class="form-select" name="type" id="type" wire:model.live="field.type">
                            <option value="product" selected>Product</option>
                            <option value="services">Services</option>
                        </select>
                        @error('field.type') <span class="text-danger">{{ $message }}</span> @enderror
                    </div>

                    <!-- Description -->
                    <div class="mb-3">
                        <label class="form-label">Description</label>
                        <textarea class="form-control" wire:model.live="field.description"></textarea>
                    </div>
                    <div class="mb-3">
                        <label for="#" class="form-label">Upload Display Product</label>
                        <label for="images" class="border rounded ratio ratio-1x1 bs-secondary-bg-rgb mb-3"
                            style="cursor: pointer; background-color: #e9ecef">
                            @if (!empty($field['logo']))
                            <div for="images" class="border rounded ratio ratio-1x1 image-upload"
                                style="background-image: url('{{ $field['logo']->temporaryUrl() }}')">
                            </div>
                            @else
                            <div
                                class="d-flex flex-column align-self-center align-items-center justify-content-center">
                                <i class="fas fa-upload fa-3x fa-fw mb-3"></i>
                                <span class="fw-light">Upload Here...</span>
                            </div>
                            @endif
                            <div class="justify-content-center align-items-center"
                                style="background-color: #e9ecef75;" wire:loading.flex wire:target="field.logo">
                                <span class="loader"></span>
                            </div>
                        </label>
                        <div>
                            <input type="file" id="images" wire:model="field.logo" name="field.logo"
                                class="form-control @error('field.logo') is-invalid @enderror"
                                placeholder="Upload imagess here...">
                            @error('field.logo')
                            <span class="invalid-feedback">
                                <strong>{{ $message }}</strong>
                            </span>
                            @enderror
                        </div>
                    </div>

                    <!-- Status -->
                    <div class="mb-3 form-check">
                        <input type="checkbox" class="form-check-input" wire:model.live="field.is_active" value="1">
                        <label class="form-check-label">Active</label>
                    </div>
                </div>
                <div class="modal-footer py-2">
                    <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-outline-primary">Changes</button>
                </div>
            </form>
        </div>
    </div>

    @include('components.modal.ModalDeleteComfrimed', ['title' => 'Data Produk', 'count' => count($selected)])
</div>


@push('script')

@endpush