@push('head')
@endpush


<div class="ppt4 container-fluid">

    <div class="d-block rounded p-3 mb-3">
        <h4 class="card-title">FAQ</h4>
        <h6 class="card-subtitle">Forum pertanyaan yang sering di ajukan</h6>
    </div>

    <div class="d-block bg-theme-box rounded-3 overflow-hidden shadow-sm">

        {{-- Header --}}
        <div class="d-flex justify-content-between align-items-center p-3">
            {{-- Bulk Action --}}
            @if (count($selected) > 0)
                <button class="btn btn-outline-danger" data-bs-toggle="modal" data-bs-target="#deleteModal">
                    <i class="fad fa-trash"></i> Hapus ({{ count($selected) }})
                </button>
            @endif
            <button class="btn btn-outline-warning ms-auto" wire:click='addNew()'>
                <i class="fa fa-plus"></i> Add_New
            </button>
        </div>

        <div class="table-responsive">
            <table class="table table-borderless mb-3">
                <thead class="table-header">
                    <tr>
                        <th></th>
                        <th width="32">
                            <input type="checkbox" wire:model.live="selectAll">
                        </th>
                        <th wire:click="sortBy('category')" style="cursor:pointer">
                            Category
                        </th>
                        <th wire:click="sortBy('question')" style="cursor:pointer">
                            Question
                        </th>
                        <th>Status</th>
                        <th wire:click="sortBy('created_at')" style="cursor:pointer">
                            Create Date
                        </th>
                        <th>Actions</th>
                    </tr>
                </thead>

                <tbody class="table-transparent">
                    @forelse($faqs as $faq)
                        <tr>
                            <td></td>
                            <td>
                                <input type="checkbox" value="{{ $faq->faq_id }}" wire:model.live="selected">
                            </td>
                            <td>
                                <span class="badge bg-primary">{{ $faq->category ?? 'General' }}</span>
                            </td>
                            <td>{{ Str::limit($faq->question, 60) }}</td>
                            <td>
                                @if ($faq->is_active)
                                    <span class="badge bg-success">Active</span>
                                @else
                                    <span class="badge bg-secondary">Inactive</span>
                                @endif
                            </td>
                            <td>{{ $faq->created_at->format('d M Y') }}</td>
                            <td>
                                <button class="btn btn-sm btn-info" wire:click="view({{ $faq->faq_id }})">
                                    <i class="fa fa-eye"></i>
                                </button>
                                <button class="btn btn-sm btn-warning" wire:click="edit({{ $faq->faq_id }})">
                                    <i class="fa fa-edit"></i>
                                </button>
                                <button class="btn btn-sm btn-danger" wire:click="delete({{ $faq->faq_id }})">
                                    <i class="fa fa-trash"></i>
                                </button>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="7" class="text-center">
                                <div class="border rounded py-5">
                                    <i class="fad fa-question-circle fa-3x mb-3"></i>
                                    <p class="fs-5 m-0">No FAQ found.</p>
                                </div>
                            </td>
                        </tr>
                    @endforelse
                </tbody>

            </table>
        </div>



        {{-- Pagination --}}
        <div class="mb-3">
            {{ $faqs->links('components.utilities.paginate') }}
        </div>


    </div>


    <!-- Modal Create Category -->
    <div class="modal fade" id="FaqModal" tabindex="-1" aria-hidden="true" wire:ignore.self>
        <div class="modal-dialog">
            <form wire:submit.prevent="submit" class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Forum Pertanyaan</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">


                    <div class="mb-3">
                        <label class="form-label">Question</label>
                        <input type="text" class="form-control" wire:model.live="field.question" @disabled($isView)>
                        @error('field.question')
                            <span class="text-danger">{{ $message }}</span>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Answer</label>
                        <textarea class="form-control" rows="4" wire:model.live="field.answer" @disabled($isView)></textarea>
                        @error('field.answer')
                            <span class="text-danger">{{ $message }}</span>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Category</label>
                        <select class="form-select" wire:model.live="field.category" @disabled($isView)>
                            <option value="General">General</option>
                            <option value="Pricing">Pricing</option>
                            <option value="Project Flow">Project Flow</option>
                            <option value="Technical">Technical</option>
                            <option value="Maintenance">Maintenance</option>
                            <option value="Legal">Legal</option>
                        </select>
                        @error('field.category')
                            <span class="text-danger">{{ $message }}</span>
                        @enderror
                    </div>

                    <div class="mb-3 form-check">
                        <input type="checkbox" class="form-check-input" wire:model.live="field.is_active" @disabled($isView)>
                        <label class="form-check-label">Active</label>
                    </div>


                </div>
                <div class="modal-footer py-2">
                    <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-outline-primary" @disabled($isView)>Changes</button>
                </div>
            </form>
        </div>
    </div>

    @include('components.modal.ModalDeleteComfrimed', [
        'title' => 'Data Produk',
        'count' => count($selected),
    ])
</div>


@push('script')
@endpush
