@push('head')
<title>PeronIT - Setup Konten Banner</title>
@endpush

<div>

    <div class="ppt4 container-fluid">
        {{-- Header --}}
        <div class="d-flex justify-content-between align-items-center rounded bg-theme-box shadow-sm p-3 mb-3">
            <div>
                <h2 class="text-them fw-bold mb-0">Content Banner</h2>
                <p class="text-them-sec mb-0">Selamat datang di konten halaman utama</p>
            </div>
            <div>
                <button class="btn btn-secondary" type="button" wire:click="new">
                    <i class="fas fa-plus fa-sm fa-fw"></i>
                    <span class="d-none d-lg-inline">Tambah</span>
                </button>
            </div>
        </div>

        <div class="d-block rounded shadow bg-theme-box mb-3">
            <div class="d-flex gap-3 align-items-center py-3 px-4">
                @if(count($selected) > 0)
                <button class="btn btn-outline-danger" data-bs-toggle="modal" data-bs-target="#deleteModal">
                    <i class="fad fa-trash"></i> Hapus ({{ count($selected) }})
                </button>
                @endif
                <div class="d-flex align-items-center ms-auto">
                    <input type="text" wire:model.live="search" class="form-control pe-4"
                        placeholder="Search Product...">
                    <i class="fad fa-search fa-sm" style="margin-left: -32px"></i>
                </div>
            </div>
            <div class="table-responsive">
                <table class="table table-borderless">
                    <thead class="table-header text-capitalize">
                        <tr>
                            <th style="widht: 24px"></th>
                            <th>
                                <input type="checkbox" wire:model.live="selectAll">
                            </th>
                            <th wire:click="sortBy('title')" style="cursor:pointer">
                                <div class="d-flex justify-content-between align-items-center">
                                    <span>title</span>
                                    @if($sortField === 'title')
                                    <i class="fa fa-sort-{{ $sortDirection }}"></i>
                                    @endif
                                </div>
                            </th>
                            <th>Description</th>
                            <th wire:click="sortBy('is_active')" style="cursor:pointer">
                                <div class="d-flex justify-content-between align-items-center">
                                    <span>Status</span>
                                    @if($sortField === 'is_active')
                                    <i class="fa fa-sort-{{ $sortDirection }}"></i>
                                    @endif
                                </div>
                            </th>
                            <th wire:click="sortBy('created_at')" style="cursor:pointer">
                                <div class="d-flex justify-content-between align-items-center">
                                    <span>Date</span>
                                    @if($sortField === 'created_at')
                                    <i class="fa fa-sort-{{ $sortDirection }}"></i>
                                    @endif
                                </div>
                            </th>
                            <th width="120" class="text-nowrap">Actions</th>
                            <th style="widht: 24px"></th>
                        </tr>
                    </thead>
                    <tbody class="table-transparent">
                        @forelse ($data as $index => $item)
                        <tr>
                            <td style="widht: 24px"></td>
                            <td>
                                <input type="checkbox" value="{{ $item->banner_id }}" wire:model.live="selected">
                            </td>
                            <td>{{ $item->title }}</td>
                            <td>{{ $item->description }}</td>
                            <td>
                                @if($item->is_active)
                                <span class="badge bg-success">Active</span>
                                @else
                                <span class="badge bg-secondary">Inactive</span>
                                @endif
                            </td>
                            <td>{{ $item->created_at }}</td>
                            <td width="120" class="text-nowrap">
                                <button class="btn btn-sm btn-info" wire:click="show({{ $item->banner_id }})">
                                    <i class="fa fa-eye"></i>
                                </button>
                                <button class="btn btn-sm btn-warning" wire:click="edit({{ $item->banner_id }})">
                                    <i class="fa fa-edit"></i>
                                </button>
                                <button class="btn btn-sm btn-danger" wire:click="delete({{ $item->banner_id }})">
                                    <i class="fa fa-trash"></i>
                                </button>
                            </td>
                            <td style="widht: 24px"></td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="9" class="text-center">
                                <div class="border rounded py-5">
                                    <i class="fad fa-box-open fa-3x fa-fw"></i>
                                    <p class="fs-3 m-0">No categories found.</p>
                                </div>
                            </td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    {{-- Modal Create --}}
    <div class="modal fade" id="modalBanner" wire:ignore.self>
        <div class="modal-dialog modal-xl">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Tambah Banner</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>

                <div class="modal-body">
                    <div class="row g-3">
                        {{-- PREVIEW --}}
                        <div class="col-12 col-lg-7">
                            {{-- Desktop Preview --}}
                            <div class="mb-3">
                                <label class="form-label fw-bold">Preview Desktop</label>
                                <div class="position-relative rounded overflow-hidden ratio ratio-21x9">
                                    @if ($form['image_desktop'] && method_exists($form['image_desktop'],
                                    'temporaryUrl'))
                                    <img src="{{ $form['image_desktop']->temporaryUrl() }}"
                                        class="img-fluid position-absolute object-fit-cover">

                                    @elseif ($form['image_desktop'])
                                    <img src="{{ $form['image_path'] . $form['image_desktop'] }}"
                                        alt="{{ $form['title'] }}" class="img-fluid position-absolute object-fit-cover">
                                    @else
                                    <div
                                        class="bg-secondary w-100 h-100 d-flex align-items-center justify-content-center text-light">
                                        No Image</div>
                                    @endif

                                    <div class="d-flex align-items-center container"
                                        style="color: {{$form['text_color']}}; justify-content: {{$form['text_position']}}">
                                        <div class="w-50"
                                            style="color: {{$form['text_color']}}; text-align: {{$form['text_position']}}">
                                            <h3 class="fw-bold mb-2">{{ $form['title'] ?: 'Banner Title' }}</h3>
                                            <p class="mb-3">{{ $form['description'] ?: 'Banner description...' }}</p>
                                            @if ($form['link'])
                                            <a href="#" class="btn btn-sm px-3"
                                                style="color : {{$form['text_color']}}; border: 1px solid {{$form['text_color']}};">
                                                {{ $form['link_text'] ?: 'Button Text' }}
                                            </a>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            </div>

                            {{-- Mobile Preview --}}
                            <div class="mb-3" style="width: 25rem;">
                                <label class="form-label fw-bold">Preview Mobile</label>
                                <div class="position-relative rounded overflow-hidden ratio ratio-1x1">
                                    @if ($form['image_mobile'] && method_exists($form['image_mobile'], 'temporaryUrl'))
                                    <img src="{{ $form['image_mobile']->temporaryUrl() }}"
                                        class="img-fluid position-absolute object-fit-cover">
                                    @elseif ($form['image_mobile'])
                                    <img src="{{ $form['image_path'] . $form['image_mobile'] }}"
                                        alt="{{ $form['title'] }}" class="img-fluid position-absolute object-fit-cover">
                                    @else
                                    <div
                                        class="bg-secondary w-100 h-100 d-flex align-items-center justify-content-center text-light">
                                        No Image</div>
                                    @endif
                                    <div class="d-flex flex-column justify-content-end text-center container pb-5"
                                        style="color: {{$form['text_color']}};">
                                        <strong>{{ $form['title'] ?: 'Title' }}</strong>
                                        <small>{{ $form['description'] ?: 'Description' }}</small>
                                    </div>
                                </div>
                            </div>
                        </div>

                        {{-- FORM INPUT --}}
                        <div class="col-12 col-lg-5">
                            <div class="mb-3">
                                <label class="form-label">Title</label>
                                <input type="text" class="form-control" wire:model.live="form.title">
                            </div>

                            <div class="mb-3">
                                <label class="form-label">Description</label>
                                <textarea class="form-control" rows="2" wire:model.live="form.description"></textarea>
                            </div>

                            <div class="row g-2 mb-3">
                                <div class="col-6">
                                    <label class="form-label">Link</label>
                                    <input type="text" class="form-control" wire:model.live="form.link">
                                </div>
                                <div class="col-6">
                                    <label class="form-label">Link Text</label>
                                    <input type="text" class="form-control" wire:model.live="form.link_text">
                                </div>
                            </div>

                            <div class="mb-3">
                                <label class="form-label">Text Position</label>
                                <div>
                                    <label class="me-2"><input type="radio" wire:model.live="form.text_position"
                                            value="left">
                                        Left</label>
                                    <label class="me-2"><input type="radio" wire:model.live="form.text_position"
                                            value="center">
                                        Center</label>
                                    <label><input type="radio" wire:model.live="form.text_position" value="right">
                                        Right</label>
                                </div>
                            </div>

                            <div class="mb-3">
                                <label class="form-label fw-bold">Text Color</label>
                                <div class="d-flex align-items-center gap-3">
                                    <input type="color" class="form-control form-control-color p-0 border-0"
                                        style="width: 3rem; height: 2.5rem;" wire:model.live="form.text_color">
                                    <span class="small text-muted">{{ $form['text_color'] }}</span>
                                </div>
                                <small class="text-muted">Pilih warna teks banner sesuai gambar (misalnya putih
                                    untuk latar gelap)</small>
                            </div>

                            <div class="mb-3">
                                <label class="form-label">Desktop Image</label>
                                <input type="file" class="form-control @error('form.image_desktop') is-invalid @enderror" wire:model.live="form.image_desktop">
                                @error('form.image_desktop')
                                    <span class="invalid-feedback">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>

                            <div class="mb-3">
                                <label class="form-label">Mobile Image</label>
                                <input type="file" class="form-control @error('form.image_mobile') is-invalid @enderror" wire:model.live="form.image_mobile">
                                @error('form.image_mobile')
                                    <span class="invalid-feedback">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>

                            <div class="row g-2 mb-3">
                                <div class="col">
                                    <label class="form-label">Start Date</label>
                                    <input type="date" class="form-control" wire:model.live="form.start_date">
                                </div>
                                <div class="col">
                                    <label class="form-label">End Date</label>
                                    <input type="date" class="form-control" wire:model.live="form.end_date">
                                </div>
                            </div>

                            <div class="row g-2">
                                <div class="col-4">
                                    <label class="form-label">Order</label>
                                    <input type="number" class="form-control" wire:model.live="form.order">
                                </div>
                                <div class="col-4">
                                    <label class="form-label">Active</label>
                                    <select class="form-select" wire:model.live="form.is_active">
                                        <option value="1">Yes</option>
                                        <option value="0">No</option>
                                    </select>
                                </div>
                                <div class="col-4">
                                    <label class="form-label">Page</label>
                                    <input type="text" class="form-control" wire:model.live="form.page">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="modal-footer">
                    <button class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button class="btn btn-primary" wire:click="store">Save</button>
                </div>
            </div>
        </div>
    </div>

    {{-- Modal Preview --}}
    <div class="modal fade" id="modalPreview">
        <div class="modal-dialog modal-xl modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h1 class="modal-title fs-5" id="staticBackdropLabel">Preview Banner</h1>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body p-0 m-0">
                    <div class="d-block ratio ratio-21x9">
                        <img src="{{ $form['image_path'] . $form['image_desktop'] }}" alt="{{ $form['title'] }}"
                            class="img-fluid" style="object-position: center; object-fit:cover;">

                        <div class="d-flex align-items-center" style="justify-content: {{$form['text_position']}}">
                            <div class="col-7">
                                <div class="p-5 mt-4" style="color: {{$form['text_color']}}; text-align: {{$form['text_position']}}">

                                    <p class="mb-2 display-5 fw-bold">{{ $form['title'] }}</p>
                                    <p class="fs-3 fw-light">{{ $form['description'] }}</p>

                                    @if ($form['link'])
                                    <a href="{{ $form['link'] }}" class="btn btn-lg px-4"
                                        style="color : {{$form['text_color']}}; border: 1px solid {{$form['text_color']}};">
                                        {{ $form['link_text'] }}
                                    </a>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>

    {{-- Modal Confrim Delete --}}
    <div class="modal fade" id="modalDelete">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-body text-center py-5">
                    <i class="fad fa-exclamation-triangle fa-3x fa-fw"></i>
                    <p class="fs-2 fw-bold mb-0">Oops!</p>
                    <p>Kamu yakin ingin menghapus?</p>
                </div>
                <div class="d-flex align-items-center justify-content-center p-3 gap-3 border-top">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancle</button>
                    <button type="button" class="btn btn-danger" wire:click='deleteAction'>Delete</button>
                </div>
            </div>
        </div>
    </div>

    {{-- Modal Delete Bulk --}}
    @include('components.modal.ModalDeleteComfrimed', ['title' => 'Data banner', 'count' => count($selected)])

</div>

@push('script')
@endpush