<!DOCTYPE html>
<html data-theme="{{ $theme }}" data-bs-theme="{{ $theme }}">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Peronit - {{$title ?? 'Pages'}}</title>
    
    @stack('head')
    <link rel="stylesheet" href="{{ asset('/assets/app/css/app.css') }}">
    <link rel="stylesheet" href="{{ asset('/assets/icons/css/all.min.css') }}">
    <link rel="stylesheet" href="{{ asset('/assets/dist/css/panel-admin.css') }}">
    <link rel="stylesheet" href="{{ asset('/assets/library/css/textEditor.css') }}">
    <link rel="stylesheet" href="{{ asset('/assets/library/css/animated.css') }}">
    <link rel="stylesheet" href="{{ asset('/assets/OwlCarousel/css/owl.carousel.min.css') }}">
    <link rel="stylesheet" href="{{ asset('/assets/OwlCarousel/css/owl.theme.default.min.css') }}">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Nunito:ital,wght@0,200..1000;1,200..1000&family=Pacifico&family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap" rel="stylesheet">
    @livewireStyles
    @vite(['resources/css/admin.css'])

</head>

<body>

    <div class="wrapper">
        <div id="nav-progress-wrapper" class="position-fixed start-0 top-0 w-100 d-none" style="z-index:9999;">
            <div class="progress" style="height: 3px;">
                <div id="nav-progress-bar" class="progress-bar text-them bg-theme-box" style="width: 0%; transition: width 0.2s;">
                </div>
            </div>
        </div>


        <div class="slider" id="sliderExample">
            <div class="slider-head">
                <div class="lh-1">
                    <p class="text-them fw-bold mb-0">{{ auth('admins')->user()->username }}</p>
                    <small class="text-them-sec">{{ auth('admins')->user()->email }}</small>
                </div>
            </div>
            <div class="slider-body">
                <div class="container">
                    <nav class="nav flex-column" id="sidebar-menu">
                        @foreach ($menus as $menu)

                        {{-- SEPARATOR --}}
                        @if ($menu->type === 'separator')
                        <hr class="soft text-them my-2">
                        @continue
                        @endif


                        @php
                        // Ambil semua route anak + parent
                        $allRoutes = collect([$menu->route])->merge($menu->children->pluck('route'))->filter()->map(fn($r) => $r . '*')->toArray();
                        $isActive = request()->routeIs($allRoutes);
                        @endphp


                        {{-- MENU ITEM UTAMA --}}
                        <a class="nav-link slider-link @if($menu->children->count() == 0) {{ $isActive ? 'active' : '' }} @else {{ $isActive ? '' : 'collapsed' }} @endif"
                            href="{{ $menu->url }}"
                            @if($menu->children->count())
                                data-bs-toggle="collapse"
                                data-bs-target="#menu-{{ $menu->menu_id }}"
                                aria-expanded="{{ $isActive ? 'true' : 'false' }}"
                            @else
                                wire:navigate
                            @endif
                            >
                            @if ($menu->icon)
                            <i class="{{ $menu->icon }}"></i>
                            @endif
                            <span class="text-capitalize">{{ $menu->name }}</span>

                            @if($menu->children->count())
                            <i class="fa-solid fa-chevron-left arrow-icon"></i>
                            @endif
                        </a>


                        {{-- SUB MENU --}}
                        @if ($menu->children->count())
                        <div id="menu-{{ $menu->menu_id }}"
                            class="accordion-collapse collapse {{ $isActive ? 'show' : '' }}"
                            data-bs-parent="#sidebar-menu">
                            @foreach ($menu->children as $child)

                            {{-- CHILD SEPARATOR --}}
                            @if ($child->type === 'separator')
                            <hr class="soft text-them">
                            @continue
                            @endif

                            <a href="{{ $child->url }}" {{-- href="{{ $child->route ? route($child->route) : '#' }}"
                                --}}
                                class="nav-link slider-link ps-3 {{ request()->routeIs($child->route . '*') ? 'active' : '' }}"
                                wire:navigate.hover>
                                @if ($child->icon)
                                <i class="{{ $child->icon }}"></i>
                                @endif
                                <span class="text-capitalize">{{ $child->name }}</span>
                            </a>

                            @endforeach
                        </div>
                        @endif

                        @endforeach

                        <a class="nav-link slider-link" type="button" id="LogOut">
                            <i class="fad fa-sign-out slider-icons"></i>LogOut
                        </a>
                    </nav>
                </div>
            </div>
        </div>

        <main class="pages">
            <nav class="navbar navbar-expand-md navbar-light">
                <div class="container-fluid">
                    <button id="sliderButton" class="btn ms-auto d-block d-md-none" type="button">
                        <i class="fas fa-bars fa-lg fa-fw"></i>
                    </button>
                    <div class="collapse navbar-collapse" id="navbarID">
                        <div class="navbar-nav gap-2 ms-auto">
                            <a class="nav-link text-them-sec" aria-current="page" href="#">
                                <i class="fas fa-bell fa-lg fa-fw"></i>
                            </a>
                            <a class="nav-link text-them-sec" aria-current="page" href="#">
                                <i class="fas fa-envelope fa-lg fa-fw"></i>
                            </a>
                            <a class="nav-link text-them-sec" aria-current="page" href="#">
                                <i class="fas fa-user fa-lg fa-fw"></i>
                            </a>
                        </div>
                    </div>
                </div>
            </nav>
            <section class="pages-main">
                {{ $slot }}
            </section>
        </main>
    </div>




    <div id="logoutModal" class="modal fade" tabindex="-1">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-body">
                    <div class="text-center pt-5 pb-3">
                        <i class="fas fa-sign-out-alt fa-5x fa-fw"></i>
                        <p>Anda yakin ingin keluar applikasi!</p>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Tidak</button>
                    <a href="#" class="btn btn-primary">Iya, keluar</a>
                </div>
            </div>
        </div>
    </div>


    <div class="sliderBackground" id="sliderBackground"></div>
    <script src="{{ asset('/assets/library/js/jquery.js') }}"></script>
    <script src="{{ asset('/assets/library/js/popper.js') }}"></script>
    <script src="{{ asset('/assets/library/js/alert.js') }}"></script>
    <script src="{{ asset('/assets/library/js/alert-handler.js') }}"></script>
    <script src="{{ asset('/assets/app/js/app.min.js') }}"></script>
    <script src="{{ asset('/assets/dist/js/panel-admin.js') }}"></script>
    <script src="{{ asset('/assets/OwlCarousel/owl.carousel.min.js') }}"></script>
    
    @stack('script')
    @livewireScripts
    @vite(['resources/js/admin.js'])
</body>

</html>