@push('head')
@endpush

<div>
    <div class="box-container overflow-hidden">
        <div class="box-head">
            <div class="text-start">
                <h2>LOGIN</h2>
                <p class="mb-0">Wellcome in login form</p>
            </div>
        </div>
        <div class="box-body">
            <form wire:submit='login'>
                <div class="mb-3">
                    <div class="position-relative">
                        <label for="email" class="position-absolute top-50 start-0 translate-middle-y text-center" style="width: 46px">
                            <i class="fas fa-envelope fa-sm fa-fw"></i>
                        </label>
                        <input type="email" id="email" class="form-control @error('email') is-invalid @enderror" style="padding-left: 46px"
                            placeholder="Email Address" wire:model='email' wire:target='login' wire:loading.class="disabled placeholder">
                    </div>
                    @error('email')
                    <span class="invalid-feedback text-capitalize">
                        <strong>{{ $errors->first('email') }}</strong>
                    </span>
                    @enderror
                </div>
                <div class="mb-3">
                    <div class="position-relative">
                        <label for="password" class="position-absolute top-50 start-0 translate-middle-y text-center" style="width: 46px">
                            <i class="fad fa-lock fa-sm fa-fw"></i>
                        </label>
                        <input type="password" id="password" class="form-control @error('password') is-invalid @enderror" style="padding-left: 46px"
                            placeholder="password Address" wire:model='password' wire:target='login' wire:loading.class="disabled placeholder">
                    </div>
                    @error('password')
                    <span class="invalid-feedback text-capitalize">
                        <strong>{{ $errors->first('password') }}</strong>
                    </span>
                    @enderror
                </div>
                <div class="mb-4 d-flex align-items-center justify-content-between">
                    <div class="form-check">
                        <input type="checkbox" class="form-check-input" id="exampleCheck1">
                        <label class="form-check-label" for="exampleCheck1">Remember Me</label>
                    </div>
                    <div>
                        <a href="#" class="text-decoration-none">Lupa Password?</a>
                    </div>
                </div>
                <div class="mb-4">
                    <button type="submit" class="btn btn-primary form-control" wire:target='login'
                    wire:loading.class="disabled placeholder">LOGIN</button>
                </div>
            </form>
        </div>
        <div class="box-footer border-top">
            <div class="d-flex align-items-center justify-content-between">
                <span class="fw-bold">Contac Administrator</span>
                <div>
                    <a href="#" class="text-decoration-none mx-2"><i class="fab fa-facebook-f"></i></a>
                    <a href="#" class="text-decoration-none mx-2"><i class="fab fa-twitter"></i></a>
                    <a href="#" class="text-decoration-none mx-2"><i class="fab fa-instagram"></i></a>
                    <a href="#" class="text-decoration-none mx-2"><i class="fab fa-linkedin-in"></i></a>
                </div>
            </div>
        </div>
    </div>

</div>

@push('script')
@endpush