// SCRIPT_THEME
var themeSystem = $("html").attr("data-theme");
document.addEventListener("livewire:navigated", () => {
    setThemeSystem(themeSystem);
});
document.addEventListener("livewire:init", () => {
    setThemeSystem(themeSystem);
});
window.addEventListener("theme-changed", (theme) => {
    // setThemeSystem(theme.detail.theme);
    location.reload();
});
function setThemeSystem(theme) {
    if (theme === "system" || theme === null) {
        const isDark = window.matchMedia("(prefers-color-scheme: dark)").matches;
        theme = isDark ? "dark" : "light";
    }
    $("html").attr("data-theme", theme);
    $("html").attr("data-bs-theme", theme);
    localStorage.setItem("theme", theme);
}


// SCRIPT_ACTION
$(document).ready(function () {
    // SLIDER_ACTION
    $("#sliderButton").click(function (event) {
        if ($("#sliderExample").hasClass("active")) {
            $("#sliderExample").removeClass("active");
            $("#sliderBackground").removeClass("active");
        } else {
            $("#sliderExample").addClass("active");
            $("#sliderBackground").addClass("active");
        }
    });
    $("#sliderBackground").click(function () {
        $("#sliderExample").removeClass("active");
        $("#sliderBackground").removeClass("active");
    });

    //LOGOUT_ACTION
    $("#LogOut").click(() => {
        Swal.fire({
            title: "Are you sure?",
            text: "You won't be able to logout!",
            icon: "warning",
            showCancelButton: true,
            confirmButtonColor: "#3085d6",
            cancelButtonColor: "#d33",
            confirmButtonText: "Yes, logout!",
        }).then((result) => {
            if (result.isConfirmed) {
                window.location.href = "/admin/logout";
            }
        });
    });
});

// SCRIPT_MODAL
$(document).ready(function () {
    // Close Modal
    $(document).on("closeModal", function (event) {
        let modalId = event.originalEvent.detail.id;
        let $modal = $("#" + modalId);

        if ($modal.length) {
            let modalInstance = bootstrap.Modal.getInstance($modal[0]);
            if (modalInstance) {
                modalInstance.hide();
            }
        }
    });
    // Open Modal
    $(document).on("openModal", function (event) {
        let modalId = event.originalEvent.detail.id;
        let $modal = $("#" + modalId);

        if ($modal.length) {
            let modalInstance = bootstrap.Modal.getOrCreateInstance($modal[0]);
            modalInstance.show();
        }
    });
});

// SCRIPT_NAVIGATE
$(document).ready(function () {
    let progress = 0;
    let interval = null;

    document.addEventListener("livewire:navigating", () => {
        // Tampilkan progress bar
        $("#nav-progress-wrapper").removeClass("d-none").addClass("d-block");

        progress = 0;
        $("#nav-progress-bar").css("width", "0%");

        // animasi 0–90%
        interval = setInterval(() => {
            if (progress < 90) {
                progress += 5;
                $("#nav-progress-bar").css("width", progress + "%");
            }
        }, 100);
    });

    document.addEventListener("livewire:navigated", () => {
        // langsung ke 100%
        $("#nav-progress-bar").css("width", "100%");

        // delay sebentar lalu hide
        setTimeout(() => {
            $("#nav-progress-wrapper")
                .removeClass("d-block")
                .addClass("d-none");

            $("#nav-progress-bar").css("width", "0%");
            clearInterval(interval);
        }, 300);
    });
});


document.addEventListener('livewire:init', () => {
            const script = document.createElement('script');
            script.src = "{{ asset('assets/editor/ckeditor.js') }}";
            document.body.appendChild(script);
        });