<?php

namespace Database\Seeders;

use App\Models\Admin;
use App\Models\Media;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Http\UploadedFile;

class AdminSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $admin = Admin::create([
            'username' => 'Admin Peronit',
            'slug' => 'admin-peronit',
            'email' => 'admin@peronit.co.id',
            'password' => bcrypt('Admin2025'),
            'gender' => 'P',
            'born' => date('Y-m-d'),
            'phone' => '087778335325',
            'country' => 'indonesia',
            'avatar' => 'admin.png',
            'address' => '',
            'is_active' => 1,
        ]);

        // Path file dari public
        $path = public_path('images/default/admin.png');

        // Convert ke UploadedFile
        $file = new UploadedFile($path, 'admin.png', mime_content_type($path), null, true);

        // Simpan ke media
        Media::saveMedia($admin, $file, 'ADM', true);
    }
}
