<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('testimonials', function (Blueprint $table) {
            $table->id('testimonial_id');
            $table->string('author_name')->nullable(); // Jika ingin custom nama selain client
            $table->string('position')->nullable(); // Jabatan klien
            $table->string('company')->nullable(); // Nama perusahaan klien
            $table->text('message'); // Isi testimonial
            $table->unsignedTinyInteger('rating')->nullable(); // 1-5
            $table->boolean('is_active')->default(true); // untuk status tampil / tidak

            $table->timestamps();
            
            $table->unsignedBigInteger('client_id')->nullable();
            $table->foreign('client_id')->references('client_id')->on('clients')->nullOnDelete();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('testimonials');
    }
};
