<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('projects', function (Blueprint $table) {
            $table->id('project_id');

            // Basic info
            $table->string('title')->index();
            $table->string('slug')->unique();
            $table->string('client_name')->nullable();

            // Description
            $table->longText('description')->nullable();
            $table->text('description_short')->nullable();
            $table->json('description_list')->nullable();

            // Tech & feature (JSON)
            $table->json('tech_stack')->nullable();
            $table->json('features')->nullable();

            // Metadata project
            $table->enum('status', ['draft', 'on-progress', 'completed', 'archived'])->default('draft');
            $table->string('version')->nullable();
            $table->date('start_date')->nullable();
            $table->date('end_date')->nullable();

            // Business optional
            $table->decimal('price', 15, 2)->nullable();

            // External links
            $table->string('demo_url')->nullable();
            $table->string('repo_url')->nullable();

            // Status flags
            $table->boolean('is_active')->default(true);
            $table->boolean('is_featured')->default(false);
            $table->boolean('is_new')->default(false);

            // Tracking
            $table->unsignedBigInteger('created_by')->nullable();
            $table->unsignedBigInteger('updated_by')->nullable();

            // Category relationships
            $table->unsignedBigInteger('client_id')->nullable();
            $table->unsignedBigInteger('category_id')->nullable();
            $table->unsignedBigInteger('sub_category_id')->nullable();
            $table->unsignedBigInteger('child_category_id')->nullable();

            // FK - Category
            $table->foreign('client_id')->references('client_id')->on('clients')->nullOnDelete();
            $table->foreign('category_id')->references('category_id')->on('categories')->nullOnDelete();
            $table->foreign('sub_category_id')->references('category_id')->on('categories')->nullOnDelete();
            $table->foreign('child_category_id')->references('category_id')->on('categories')->nullOnDelete();


            // Indexing optimasi
            $table->index(['is_active', 'is_featured', 'is_new']);
            $table->index(['category_id', 'client_id']);
            $table->index('price');

            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('projects');
    }
};
