<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('activity_logs', function (Blueprint $table) {
            $table->bigIncrements('activity_id');

            $table->unsignedBigInteger('user_id')->nullable(); // siapa yg melakukan
            $table->string('action'); // created, updated, deleted

            // polymorphic target model
            $table->unsignedBigInteger('loggable_id');
            $table->string('loggable_type');

            // data sebelum & sesudah perubahan
            $table->json('before')->nullable();
            $table->json('after')->nullable();

            // tambahan
            $table->string('ip_address')->nullable();
            $table->text('user_agent')->nullable();

            $table->timestamps();

            $table->index(['loggable_id', 'loggable_type']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('activity_logs');
    }
};
