<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('products', function (Blueprint $table) {
            // Primary
            $table->bigIncrements('product_id');

            // Basic info
            $table->string('sku')->unique();
            $table->string('slug')->unique();
            $table->string('name');
            $table->longText('description')->nullable();
            $table->text('description_short')->nullable();
            $table->json('description_list')->nullable();
            $table->string('type')->default('product');

            // Pricing
            $table->decimal('price', 12, 2);
            $table->decimal('discount_price', 12, 2)->nullable();
            $table->enum('discount_type', ['percent', 'fixed'])->nullable();

            // Stock
            $table->integer('stock')->default(0);
            $table->boolean('sold_out')->default(false);
            $table->unsignedBigInteger('sold_count')->default(0);

            // Status flags
            $table->boolean('is_active')->default(true);
            $table->boolean('is_featured')->default(false);
            $table->boolean('is_new')->default(false);

            // Category & brand relationships
            $table->unsignedBigInteger('category_id')->nullable();
            $table->unsignedBigInteger('brand_id')->nullable();

            // Product dimensions
            $table->decimal('weight', 10, 2)->nullable();
            $table->decimal('length', 10, 2)->nullable();
            $table->decimal('width', 10, 2)->nullable();
            $table->decimal('height', 10, 2)->nullable();
            $table->string('unit')->nullable(); // ex: pcs, box, kg

            // Tracking
            $table->unsignedBigInteger('created_by')->nullable();
            $table->unsignedBigInteger('updated_by')->nullable();

            $table->timestamps();
            $table->softDeletes();

            // FK - Category & Brand
            $table->foreign('category_id')->references('category_id')->on('categories')->onDelete('set null');
            $table->foreign('brand_id')->references('brand_id')->on('brands')->onDelete('set null');

            // Indexing optimasi e-commerce
            $table->index(['is_active', 'is_featured']);
            $table->index(['category_id', 'brand_id']);
            $table->index('price');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('products');
    }
};
