<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('content_banners', function (Blueprint $table) {
            $table->id('banner_id'); // singular, lebih konsisten
            $table->string('title')->nullable();
            $table->text('description')->nullable(); // text lebih cocok untuk deskripsi panjang
            $table->string('link')->nullable(); // ganti 'linked' biar lebih umum
            $table->string('link_text')->nullable(); // gunakan snake_case
            $table->string('image_path')->nullable(); // path utama
            $table->string('image_desktop')->nullable(); // resolusi desktop
            $table->string('image_mobile')->nullable(); // resolusi mobile
            $table->enum('text_position', ['left', 'center', 'right'])->default('center'); // lebih terkontrol
            $table->string('text_color')->default('#000000'); // warna teks
            $table->boolean('is_active')->default(true); // untuk toggle aktif/nonaktif
            $table->integer('order')->default(0); // urutan tampil
            $table->string('page')->nullable(); // halaman atau lokasi banner (misal: home, product, about)
            $table->timestamp('start_date')->nullable(); // jadwal tampil (opsional)
            $table->timestamp('end_date')->nullable();   // jadwal selesai tampil (opsional)
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('content_banners');
    }
};
