<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('media', function (Blueprint $table) {
            $table->bigIncrements('media_id'); // PK

            // Polymorphic fields
            $table->unsignedBigInteger('mediable_id');
            $table->string('mediable_type');

            // File detail
            $table->string('filename');
            $table->string('extension', 10)->nullable();
            $table->string('mime_type', 50)->nullable();
            $table->unsignedBigInteger('size')->nullable();
            $table->string('path'); // storage path

            // Optional meta
            $table->boolean('is_primary')->default(false);
            $table->string('media_type')->default('image'); // image, video, file
            $table->integer('sort_order')->default(0);

            $table->timestamps();
            $table->softDeletes();

            // Indexing
            $table->index(['mediable_id', 'mediable_type']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('media');
    }
};
