<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('seo_metas', function (Blueprint $table) {
            $table->bigIncrements('seo_id');

            // Polymorphic relation
            $table->unsignedBigInteger('seoble_id');    // ID dari produk/blog/news
            $table->string('seoble_type');              // Model class (Product::class, Blog::class)

            // SEO fields
            $table->string('meta_title')->nullable();
            $table->text('meta_description')->nullable();
            $table->text('meta_keywords')->nullable();
            $table->string('meta_image')->nullable();    // optional og:image

            $table->timestamps();

            // index untuk speed
            $table->index(['seoble_id', 'seoble_type']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('seo_metas');
    }
};
