<?php 

namespace App\Traits;

use App\Models\ActivityLog;
use Illuminate\Support\Facades\Auth;

trait WithTracksActivity
{
    public static function bootTracksActivity()
    {
        static::created(function ($model) {
            $model->recordActivity('created');
        });

        static::updated(function ($model) {
            $model->recordActivity('updated');
        });

        static::deleted(function ($model) {
            $model->recordActivity('deleted');
        });
    }

    protected function recordActivity($action)
    {
        ActivityLog::create([
            'user_id'       => Auth::id(),
            'action'        => $action,
            'loggable_id'   => $this->getKey(),
            'loggable_type' => get_class($this),
            'before'        => $action === 'updated' ? $this->getOriginal() : null,
            'after'         => $action !== 'deleted' ? $this->getAttributes() : null,
            'ip_address'    => request()->ip(),
            'user_agent'    => request()->userAgent(),
        ]);
    }
}
