<?php

namespace App\Traits;

trait WithBulkDeleteActions 
{
    protected string $modelClassClass;

    public $selected = [];
    public $selectAll = false;

    public function updatedSelectAll($value)
    {
        $primaryKey = (new $this->modelClass)->getKeyName();

        if ($value) {
            $this->selected = $this->modelClass::pluck($primaryKey)->toArray();
        } else {
            $this->selected = [];
        }
    }

    public function deleteSelected()
    {
        $primaryKey = (new $this->modelClass)->getKeyName();
        $this->modelClass::whereIn($primaryKey, $this->selected)->delete();
        $this->selected = [];
        $this->selectAll = false;
        $this->dispatch('success', 'Selected all data deleted successfully!');
    }
    

}