<?php

namespace App\Providers;

use App\Helpers\MenuHelper;
use App\Models\Menu;
use Illuminate\Support\Facades\View;
use Illuminate\Support\ServiceProvider;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        View::composer('components.layouts.panel-admin', function ($view) {
            $theme = auth('admins')->check()
                ? (auth('admins')->user()->settings['theme'] ?? 'system')
                : 'system';
            // session(['theme' => $theme]);
            

            $view->with('theme', $theme);
            $view->with('menus', MenuHelper::getMenuItems());
        });
    }
}
