<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class SeoMeta extends Model
{
    protected $table = 'seo_metas';
    protected $primaryKey = 'seo_id';

    protected $fillable = [
        'seoble_id',
        'seoble_type',
        'meta_title',
        'meta_description',
        'meta_keywords',
        'meta_image',
    ];

    public function seoble()
    {
        return $this->morphTo();
    }


    public static function saveSeoMeta($model, $meta_title, $meta_description, $meta_keywords, $meta_image)
    {
        return $model->seometa()->updateOrCreate([
            'meta_title'       => $meta_title,
            'meta_description' => $meta_description,
            'meta_keywords'    => $meta_keywords,
            'meta_image'       => $meta_image,
        ]);
    }
}
  