<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Menu extends Model
{

    use HasFactory;
    
    protected $table = 'menus';

    protected $primaryKey = 'menu_id';

    protected $fillable = [
        'name',
        'icon',
        'url',
        'route',
        'type',
        'parent_id',
        'sort_order',
        'is_active'
    ];

    // Search by name or SKU
    public function scopeSearch($query, $term)
    {
        return $query->where(function ($q) use ($term) {
            $q->where('name', 'like', "%$term%")
                ->orWhere('url', 'like', "%$term%")
                ->orWhere('route', 'like', "%$term%")
                ->orWhere('type', 'like', "%$term%");
        });
    }

    public function parent()
    {
        return $this->belongsTo(Menu::class, 'parent_id', 'menu_id')->orderBy('sort_order');
    }

    public function children()
    {
        return $this->hasMany(Menu::class, 'parent_id', 'menu_id')->orderBy('sort_order');
    }
}
