<?php

namespace App\Models;

use Illuminate\Support\Str;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Media extends Model
{
    use SoftDeletes;

    protected $primaryKey = 'media_id';

    protected $fillable = [
        'mediable_id',
        'mediable_type',
        'filename',
        'extension',
        'mime_type',
        'size',
        'path',
        'is_primary',
        'media_type',
        'sort_order',
    ];

    public function mediable()
    {
        return $this->morphTo();
    }

    // URL accessor biar langsung dapat full path
    public function getUrlAttribute()
    {
        return asset('storage/' . $this->path);
    }

    public static function saveMedia($model, $file, $prefix = "DEF", $isPrimary = false)
    {
        $className = Str::snake(class_basename($model->getMorphClass()));
        $filenameOrigin = pathinfo($file->getClientOriginalName(), PATHINFO_FILENAME);
        $filename = $prefix . '-' . date('YmdHis') . $filenameOrigin . "." . $file->getClientOriginalExtension();
        $path = $file->storeAs('/images/media/' . $className, $filename, 's4');

        return $model->media()->updateOrCreate(
            ['is_primary' => $isPrimary],
            [
                'filename'    => $filename,
                'extension'   => $file->getClientOriginalExtension(),
                'mime_type'   => $file->getMimeType(),
                'size'        => $file->getSize(),
                'path'        => $path,
                'media_type'  => $file->getMimeType() === 'video/mp4' ? 'video' : 'image',
                'is_primary'  => $isPrimary,
            ]
        );
    }

    public function makePrimary()
    {
        // Matikan primary lain
        Media::where('mediable_type', $this->mediable_type)
            ->where('mediable_id', $this->mediable_id)
            ->update(['is_primary' => false]);

        // Nyalakan primary ini
        $this->update(['is_primary' => true]);

        return $this;
    }
}
