<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ContentPages extends Model
{
    protected $table = 'content_pages';

    protected $fillable = [
        'category',
        'slug',
        'title',
        'body',
        'is_active',
        'sort_order',
        'published_at',
    ];

    protected $casts = [
        'is_active'    => 'boolean',
        'published_at' => 'datetime',
    ];

    /**
     * Scope: hanya konten aktif & sudah publish
     */
    public function scopePublished($query)
    {
        return $query
            ->where('is_active', true)
            ->where(function ($q) {
                $q->whereNull('published_at')
                    ->orWhere('published_at', '<=', now());
            });
    }

    /**
     * Scope: filter berdasarkan category
     */
    public function scopeCategory($query, string $category)
    {
        return $query->where('category', $category);
    }

    /**
     * Route model binding by slug
     */
    public function getRouteKeyName()
    {
        return 'slug';
    }



    // Polymorphic SEO
    public function seometa()
    {
        return $this->morphOne(SeoMeta::class, 'seoble');
    }

    // Polymorphic Media
    public function media()
    {
        return $this->morphMany(Media::class, 'mediable');
    }
}
