<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ContentBanner extends Model
{
    use HasFactory;

    protected $table = 'content_banners';
    protected $primaryKey = 'banner_id';

    // Field yang bisa diisi secara mass-assignment
    protected $fillable = [
        'title',
        'description',
        'link',
        'link_text',
        'image_path',
        'image_desktop',
        'image_mobile',
        'text_position',
        'text_color',
        'is_active',
        'order',
        'page',
        'start_date',
        'end_date',
    ];

    // Casting otomatis untuk tipe data tertentu
    protected $casts = [
        'is_active' => 'boolean',
        'start_date' => 'datetime',
        'end_date' => 'datetime',
    ];

}
