<?php

namespace App\Models\Client;

use App\Models\Media;
use App\Models\SeoMeta;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;

class Project extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'projects';

    protected $primaryKey = 'project_id';

    protected $fillable = [
        'title',
        'slug',
        'client_name',

        'description',
        'description_short',
        'description_list',

        'tech_stack',
        'features',

        'status',
        'version',
        'start_date',
        'end_date',

        'price',

        'demo_url',
        'repo_url',

        'is_active',
        'is_featured',
        'is_new',

        'created_by',
        'updated_by',

        'client_id',
        'category_id',
        'sub_category_id',
        'child_category_id',
    ];

    protected $casts = [
        'description_list' => 'array',
        'tech_stack'       => 'array',
        'features'         => 'array',
        'is_active'        => 'boolean',
        'is_featured'      => 'boolean',
        'is_new'           => 'boolean',
        'start_date'       => 'date',
        'end_date'         => 'date',
        'price'            => 'decimal:2',
    ];

    /*
    |--------------------------------------------------------------------------
    | RELATIONSHIPS
    |--------------------------------------------------------------------------
    */

    // CLIENT
    public function client()
    {
        return $this->belongsTo(ClientProfile::class, 'client_id');
    }

    // PRODUCT
    public function product()
    {
        return $this->belongsTo(ClientProfile::class, 'client_id');
    }

    // SEO_META
    public function seo()
    {
        return $this->morphOne(SeoMeta::class, 'seoable');
    }

    // MEDIA
    public function media()
    {
        return $this->morphMany(Media::class, 'mediable');
    }

    /*
    |--------------------------------------------------------------------------
    | SCOPES
    |--------------------------------------------------------------------------
    */

    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }

    public function scopeFeatured($query)
    {
        return $query->where('is_featured', true);
    }

    public function scopeNew($query)
    {
        return $query->where('is_new', true);
    }
}
