<?php

namespace App\Models\Client;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ClientProfile extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'clients';

    protected $primaryKey = 'client_id';

    protected $fillable = [
        'name',
        'company_name',
        'email',
        'phone',
        'website',
        'is_active',
    ];

    public function projects()
    {
        return $this->hasMany(Project::class, 'client_id');
    }

    public function testimonail()
    {
        return $this->hasMany(Testimonial::class, 'client_id');
    }
}
