<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Brand extends Model
{
    use SoftDeletes;

    protected $table = 'brands';
    protected $primaryKey = 'brand_id';

    protected $fillable = [
        'slug',
        'name',
        'description',
        'logo',
        'type',
        'is_active'
    ];

    public function media()
    {
        return $this->morphMany(Media::class, 'mediable');
    }
}
