<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;

class Admin extends Authenticatable
{
    use HasFactory, Notifiable;

    protected $table = 'admins';

    protected $primaryKey = 'admin_id';

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'username',
        'slug',
        'email',
        'password',
        'gender',
        'born',
        'phone',
        'country',
        'avatar',
        'address',
        'is_active',
        'settings',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
        'settings' => 'array',
    ];
    
    // Relasi ke log aktivitas yang dilakukan admin
    public function media()
    {
        return $this->morphMany(Media::class, 'mediable');
    }

    // Relasi ke log aktivitas yang dilakukan admin
    public function activities()
    {
        return $this->morphMany(ActivityLog::class, 'causer');
    }

    // Contoh penggunaan relasi
    // ActivityLog::create([
    //     'causer_id' => $admin->id,
    //     'causer_type' => Admin::class,
    //     'action' => 'update product',
    //     'message' => 'Admin mengubah harga produk',
    // ]);
}
