<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ActivityLog extends Model
{
    protected $table = 'activity_logs';
    protected $primaryKey = 'log_id';

    protected $fillable = [
        'subject_id',
        'subject_type',
        'causer_id',
        'causer_type',
        'action',
        'message',
        'changes',
        'ip_address',
        'user_agent',
    ];

    protected $casts = [
        'changes' => 'array',
    ];

    // Relasi ke model yang diubah
    public function subject()
    {
        return $this->morphTo();
    }

    // Relasi ke user/admin yang melakukan aksi
    public function causer()
    {
        return $this->morphTo();
    }
}

