<?php

namespace App\Http\Livewire\Setting;

use App\Models\Admin;
use Livewire\Attributes\Layout;
use Livewire\Attributes\On;
use Livewire\Attributes\Title;
use Livewire\Component;


#[Layout('components.layouts.panel-admin')]
#[Title('Menu dashboard peronit')]
class SettingAppearance extends Component
{

    public $theme;

    public function updatedTheme($value)
    {
        $admin_id = auth('admins')->user();
        $admin = Admin::find($admin_id->admin_id);
        
        // simpan ke DB
        $admin->settings = ['theme' => $value];
        $admin->save();

        $this->dispatch('theme-changed', theme: $value);
    }

    public function mount()
    {
        $this->theme = auth('admins')->user()->settings['theme'] ?? 'system';
    }
    
    public function render()
    {
        return view('setting.setting-appearance');
    }
}
