<?php

namespace App\Http\Livewire\Products\ProductServices;

use App\Traits\WithBulkDeleteActions;
use Livewire\Component;
use Livewire\WithPagination;
use App\Models\Category;
use App\Models\Brand;
use App\Models\Products;
use Livewire\Attributes\Layout;
use Livewire\Attributes\Title;

#[Layout('components.layouts.panel-admin')]
#[Title('Data product')]
class ProductServicesDataAdmin extends Component
{
    use WithPagination, WithBulkDeleteActions;

    protected string $modelClass = Products::class;

    public $search;
    public $pages = 15;

    public $sortField = 'product_id';
    public $sortDirection = 'asc';

    // reset pagination ketika search/filter berubah
    public function updating($field)
    {
        if (in_array($field, ['search', 'min_price', 'max_price', 'category_id', 'brand_id'])) {
            $this->resetPage();
        }
    }

    public function sortBy($field)
    {
        if ($this->sortField === $field) {
            $this->sortDirection = $this->sortDirection === 'asc' ? 'desc' : 'asc';
        } else {
            $this->sortField = $field;
            $this->sortDirection = 'asc';
        }
    }

    public function delete($id)
    {
        $this->modelClass::find($id)->delete();
        $this->selected = array_diff($this->selected, [$id]);
        $this->dispatch('success', 'Product deleted successfully!');
    }

    public function render()
    {
        $products = Products::with('category')->orderBy($this->sortField, $this->sortDirection)
            ->Search($this->search)
            ->paginate($this->pages);
        // dd($products->category->name);

        return view('products.productServices.product-services-data-admin', [
            'products' => $products
        ]);
    }
}
