<?php

namespace App\Http\Livewire\Information;

use App\Models\Faq as ModelsFaq;
use App\Traits\WithBulkDeleteActions;
use Livewire\Attributes\Layout;
use Livewire\Attributes\Title;
use Livewire\Component;
use Livewire\WithPagination;
use Illuminate\Support\Str;

#[Layout("components.layouts.panel-admin")]
#[Title("Forum pertanyaan yang sering di ajukan")]
class Faq extends Component
{
    use WithPagination, WithBulkDeleteActions;

    protected string $modelClass = ModelsFaq::class;

    public $search, $pages = 15, $sortField = 'faq_id', $sortDirection = 'asc',  $isView = false;
    public $field = [
            'faq_id' => null,
        'category' => 'General',
        'question' => '',
        'answer' => '',
        'is_active' => true,
    ];

    protected $rules = [
        'field.category' => 'required|string|max:50',
        'field.question' => 'required|string|max:255',
        'field.answer'   => 'required|string',
        'field.is_active' => 'boolean',

    ];

    protected $messages = [
        'field.category.required' => 'kategori wajib diisi.',
        'field.category.string'   => 'kategori harus berupa teks.',
        'field.category.max'      => 'kategori maksimal 255 karakter.',
        'field.question.required' => 'question kategori wajib diisi.',
        'field.question.string'   => 'question harus berupa teks.',
        'field.question.max'      => 'question maksimal 255 karakter.',
        'field.answer.required'   => 'answer wajib diisi.',
        'field.answer.string'     => 'answer harus berupa teks.',
        'field.is_active.boolean'  => 'Status aktif harus berupa true/false.',
    ];

    public function sortBy($field)
    {
        if ($this->sortField === $field) {
            $this->sortDirection = $this->sortDirection === 'asc' ? 'desc' : 'asc';
        } else {
            $this->sortField = $field;
            $this->sortDirection = 'asc';
        }
    }
    
    protected function resetForm()
    {
        $this->resetValidation();
        $this->field = [
            'faq_id' => null,
            'category' => 'General',
            'question' => '',
            'answer' => '',
            'is_active' => true,
        ];
    }


    public function addNew()
    {
        $this->isView = false;
        $this->resetForm();
        $this->dispatch('openModal', id: 'FaqModal');
    }

    public function edit($id)
    {
        $this->isView = false;
        $this->resetForm();
        $this->field = ModelsFaq::find($id)->toArray();
        $this->dispatch('openModal', id: 'FaqModal');
    }

    public function submit()
    {
        $this->validate();

        $brand = ModelsFaq::updateOrCreate(
            ['faq_id' => $this->field['faq_id']], // kondisi
            [
                'category' => $this->field['category'],
                'question' => $this->field['question'],
                'answer'   => $this->field['answer'],
                'is_active'=> $this->field['is_active'],
            ]
        );

        $this->resetForm();
        $this->dispatch('success', 'Category created successfully!');
        $this->dispatch('closeModal', id: 'FaqModal');
    }

    public function delete($id)
    {
        ModelsFaq::findOrFail($id)->delete();
    }

    public function view($id)
    {
        $this->isView = true;
        $this->resetForm();
        $this->field = ModelsFaq::find($id)->toArray();
        $this->dispatch('openModal', id: 'FaqModal');
    }

    public function render()
    {
        $data = ModelsFaq::orderBy($this->sortField, $this->sortDirection)
            ->Search($this->search)
            ->paginate($this->pages);
        return view('information.faq', [
            'faqs' => $data
        ]);
    }
}
