<?php

namespace App\Http\Livewire\Auth;

use Illuminate\Support\Facades\Auth;
use Livewire\Attributes\Layout;
use Livewire\Attributes\Title;
use Livewire\Component;


#[Layout('components.layouts.panel-auth')]
#[Title('Admin Login form')]
class AuthAdminLogin extends Component
{
    public $email, $password;

    protected $rules = [
        'email' => 'required|min:4|email|max:255',
        'password' => 'required|min:8',
    ];

    protected $messages = [
        'email.required' => 'Alamat email tidak boleh kosong!',
        'email.min' => 'Alamat email tidak dikenal!',
        'email.email' => 'Alamat email tidak dikenal!',
        'email.max' => 'Alamat email tidak dikenal!',
        'password.required' => 'Password tidak boleh kosong!',
        'password.min' => 'Password tidak boleh kurang dari 8 karakter!',
    ];


    public function login()
    {
        $this->validate();

        if (Auth::guard('admins')->attempt(['email' => $this->email, 'password' => $this->password])) {
            return redirect()->intended()->route('admin.dashboard');
        } else {
            $this->dispatch('error', 'Your email and password failed!');
        }
    }

    public function render()
    {
        return view('auth.auth-admin-login');
    }
}
