<?php

namespace App\Http\Livewire\Account\Profile;

use App\Models\Admin;
use Livewire\Attributes\Layout;
use Livewire\Attributes\On;
use Livewire\Attributes\Title;
use Livewire\Component;
use Livewire\WithFileUploads;

#[Layout('components.layouts.panel-admin')]
#[Title('My profile management')]
class ProfileAdmin extends Component
{
    use WithFileUploads;
    // use AdminPassword;

    public $admin;

    public function mount()
    {
        $this->admin = Admin::find(auth('admins')->user()->admin_id);
        // $this->admin = $data->toArray();
        // $this->admin['images'] = $data->media()->first() ?? null;
    }


    #[On('profile-refresh')]
    public function refreshProfile()
    {
        $this->admin->refresh();
    }

    public function render()
    {
        return view('account.profile.profile-admin');
    }
}
