<?php

namespace App\Http\Controllers\api\product;

use App\Helpers\HelperApiResponse;
use App\Http\Controllers\Controller;
use App\Models\Products;
use Illuminate\Http\Request;

class productServices extends Controller
{
    protected HelperApiResponse $result;

    public function __construct(HelperApiResponse $response)
    {
        $this->result = $response;
    }


    // PRODUCT_DATA
    public function data()
    {
        //Call_HelperApiResponse
        try {
            //Fetch Product Services
            $data = Products::where('type', 'services')
                ->where('is_active', true)
                ->with(['category', 'media'])
                ->get();

            $result = $this->result->responsed(true, 'Product Services fetched successfully', $data, 200);
        } catch (\Throwable $th) {
            $result = $this->result->responsed(false, 'Something went wrong : ' . $th->getMessage(), null, 500);
        }

        return $result;
    }

     public function productCategoryId($id)
    {
        try {
            //Fetch Product Services
            $data = Products::where('type', 'services')
            ->where('is_active', true)
            ->where('category_id', $id)
            ->with(['category', 'media'])
            ->get();

            $result = $this->result->responsed(true, 'Product Services fetched successfully', $data, 200);
        } catch (\Throwable $th) {
            $result = $this->result->responsed(false, 'Something went wrong : ' . $th->getMessage(), null, 500);
        }

        return $result;
    }

    public function productCategoryName($request)
    {
        try {
            //Fetch Product Services
            $data = Products::where('type', 'services')
            ->where('is_active', true)
            ->whereHas('category', fn ($q) => 
                $q->where('name', $request)
            )
            ->with(['category', 'media'])
            ->get();

            $result = $this->result->responsed(true, 'Product Services fetched successfully', $data, 200);
        } catch (\Throwable $th) {
            $result = $this->result->responsed(false, 'Something went wrong : ' . $th->getMessage(), null, 500);
        }

        return $result;
    }
}
