<?php

namespace App\Helpers;

use App\Models\Menu;
use Illuminate\Support\Facades\Route;
class MenuHelper {

    public static function getMenuItems()
    {
        return Menu::whereNull('parent_id')
            ->orderBy('sort_order')
            ->get()
            ->map(function ($menu) {

                $validRoute = $menu->route && Route::has($menu->route);

                $url = '#';
                if ($menu->type === 'item') {
                    if ($validRoute) {
                        $url = route($menu->route);
                    } elseif ($menu->url) {
                        $url = $menu->url;
                    }
                }

                return (object)[
                    'menu_id'   => $menu->menu_id,
                    'name'      => $menu->name,
                    'icon'      => $menu->icon,
                    'type'      => $menu->type,
                    'url'       => $url,
                    'route'     => $menu->route,
                    'children'  => self::getMenuChildren($menu),
                ];
            });
    }

    public static function getMenuChildren($menu)
    {
        return $menu->children
            ->sortBy('sort_order')
            ->map(function ($child) {

                $validRoute = $child->route && Route::has($child->route);

                $url = '#';
                if ($child->type === 'item') {
                    if ($validRoute) {
                        $url = route($child->route);
                    } elseif ($child->url) {
                        $url = $child->url;
                    }
                }

                return (object)[
                    'menu_id'   => $child->menu_id,
                    'name'      => $child->name,
                    'icon'      => $child->icon,
                    'type'      => $child->type,
                    'url'       => $url,
                    'route'     => $child->route,
                    'children'  => self::getMenuChildren($child),
                ];
            });
    }
}
