<?php

namespace App\Helpers;

use Illuminate\Support\Facades\DB;

class HelperGenerateSku
{
    public static function generate($table, $prefix = 'PRD')
    {
        $date = now()->format('Ymd');
        $base = "{$prefix}-{$date}-";

        // Ambil SKU terakhir hari ini
        $last = DB::table($table)
            ->where('sku', 'like', "{$base}%")
            ->orderBy('sku', 'desc')
            ->value('sku');

        if ($last) {
            $number = (int) substr($last, -4) + 1;
        } else {
            $number = 1;
        }

        return $base . str_pad($number, 4, '0', STR_PAD_LEFT);
    }
}
