<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;

class GenerateSeeder extends Command
{
    protected $signature = 'generate:seeder {table}';
    protected $description = 'Generate seeder from existing database table';

    public function handle()
    {
        $table = $this->argument('table');

        $data = DB::table($table)->get();

        if ($data->isEmpty()) {
            $this->error("Table '$table' is empty!");
            return;
        }

        $array = var_export($data->map(function ($item) {
            return (array) $item;
        })->toArray(), true);

        $className = ucfirst($table) . 'Seeder';

        $seeder = "<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class $className extends Seeder
{
    public function run()
    {
        DB::table('$table')->insert($array);
    }
}
";

        file_put_contents(database_path("seeders/{$className}.php"), $seeder);

        $this->info("Seeder generated: database/seeders/{$className}.php");
    }
}
